/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.ejb;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;
import org.jboss.security.plugins.SecurityContextAssociation;

public class SecurityActions {
    public static Principal getCallerPrincipal(final SecurityContext securityContext) {
        return (Principal)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Principal caller = null;
                if (securityContext != null && (caller = securityContext.getIncomingRunAs()) == null) {
                    caller = securityContext.getUtil().getUserPrincipal();
                }
                return caller;
            }
        });
    }

    public static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Exception getContextException() {
        return (Exception)AccessController.doPrivileged(new PrivilegedAction(){
            static final String EX_KEY = "org.jboss.security.exception";

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return sc.getData().get(EX_KEY);
            }
        });
    }
}

