/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.ejb;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.authorization.Resource;
import org.jboss.security.integration.ejb.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityHelper {
    protected SecurityContext securityContext;
    protected static Logger log = null;

    public SecurityHelper(SecurityContext sc) {
        log = Logger.getLogger(this.getClass());
        if (sc == null) {
            sc = SecurityActions.getSecurityContext();
        }
        if (sc == null) {
            throw new IllegalArgumentException("Security Context is null");
        }
        this.securityContext = sc;
    }

    protected void authorizationAudit(String level, Resource resource, Exception e) {
        if (this.securityContext.getAuditManager() == null) {
            return;
        }
        String exceptionMessage = e != null ? e.getLocalizedMessage() : "";
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.putAll(resource.getMap());
        cmap.put("Resource:", resource.toString());
        cmap.put("Exception:", exceptionMessage);
        this.audit(level, cmap, null);
    }

    protected void audit(String level, Map<String, Object> contextMap, Exception e) {
        AuditManager am = this.securityContext.getAuditManager();
        if (am == null) {
            return;
        }
        contextMap.put("Source", this.getClass().getName());
        AuditEvent ae = new AuditEvent(level, contextMap, e);
        am.audit(ae);
    }

    protected Map<String, Object> getContextMap(Principal principal, String methodName) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        cmap.put("method", methodName);
        return cmap;
    }
}

