/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.SecurityContextAssociation;

public class SubjectPolicyContextHandler
implements PolicyContextHandler {
    public static final HashSet EMPTY_SET = new HashSet();

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (!key.equalsIgnoreCase("javax.security.auth.Subject.container")) {
            return null;
        }
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    public String[] getKeys() throws PolicyContextException {
        String[] keys = new String[]{"javax.security.auth.Subject.container"};
        return keys;
    }

    public boolean supports(String key) throws PolicyContextException {
        return key.equalsIgnoreCase("javax.security.auth.Subject.container");
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            SubjectInfo si;
            Subject theSubject = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null && (si = sc.getSubjectInfo()) != null) {
                Subject activeSubject = si.getAuthenticatedSubject();
                RunAsIdentity callerRunAsIdentity = (RunAsIdentity)sc.getIncomingRunAs();
                if (activeSubject != null) {
                    Set<Principal> principalsSet = null;
                    principalsSet = callerRunAsIdentity == null ? activeSubject.getPrincipals() : callerRunAsIdentity.getPrincipalsSet();
                    theSubject = new Subject(true, principalsSet, activeSubject.getPublicCredentials(), activeSubject.getPrivateCredentials());
                } else if (callerRunAsIdentity != null) {
                    Set<Principal> principalsSet = callerRunAsIdentity.getPrincipalsSet();
                    theSubject = new Subject(true, principalsSet, EMPTY_SET, EMPTY_SET);
                }
            }
            return theSubject;
        }
    }
}

