/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectsCache;
import org.jboss.serial.persister.ClassReferencePersister;
import org.jboss.serial.persister.PersistResolver;
import org.jboss.serial.persister.Persister;
import org.jboss.serial.util.ClassMetaConsts;

public class ObjectDescriptorFactory
implements ClassMetaConsts {
    private static final Logger log = Logger.getLogger((Class)ObjectDescriptorFactory.class);
    private static final boolean isDebug = log.isDebugEnabled();

    static Object objectFromDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        Object description = null;
        byte byteIdentify = cache.getInput().readByte();
        if (byteIdentify == 60) {
            cache.reset();
            return ObjectDescriptorFactory.objectFromDescription(cache, input);
        }
        if (byteIdentify == 99) {
            return null;
        }
        if (byteIdentify == 51) {
            if (isDebug) {
                log.debug((Object)"objectFromDescription::reading new definition");
            }
            return ObjectDescriptorFactory.readObjectDescriptionFromStreaming(cache, input.readObjectReference(), input);
        }
        if (byteIdentify == 50) {
            int reference = input.readObjectReference();
            if (isDebug) {
                log.debug((Object)("objectFromDescription::reading reference from safeClone=" + reference));
            }
            if (cache.getSafeToReuse() == null) {
                throw new IOException("SafeClone repository mismatch");
            }
            description = cache.getSafeToReuse().findReference(reference);
            if (description == null) {
                throw new IOException("SafeClone repository mismatch - didn't find reference " + reference);
            }
            return description;
        }
        if (byteIdentify == 3) {
            int reference = input.readObjectReference();
            if (isDebug) {
                log.debug((Object)("objectFromDescription::reading circular definition reference=" + reference));
            }
            if (description == null) {
                description = cache.findObjectInCacheRead(reference);
            }
            if (description == null) {
                throw new SerializationException("Object reference " + reference + " was not found");
            }
            return description;
        }
        return input.readImmutable(byteIdentify, cache);
    }

    static void describeObject(ObjectsCache cache, Object obj) throws IOException {
        Object orig;
        ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
        if (obj == null) {
            outputParent.writeByte(99);
            return;
        }
        if (obj != null && ClassMetamodelFactory.isImmutable(obj.getClass())) {
            outputParent.saveImmutable(cache, obj);
            return;
        }
        if (isDebug && obj == null) {
            log.debug((Object)"obj==null", (Throwable)new Exception());
        }
        if (isDebug) {
            log.debug((Object)("describeObject for class=" + obj.getClass().getName()));
        }
        ClassMetaData metaData = null;
        if (obj instanceof Class) {
            metaData = ClassMetamodelFactory.getClassMetaData((Class)obj, cache.isCheckSerializableClass());
        } else {
            metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
            if (metaData.getWriteReplaceMethod() != null) {
                if (isDebug) {
                    log.debug((Object)("describeObject::Calling writeReplace for " + metaData.getClazz().getName()));
                }
                try {
                    orig = obj;
                    obj = metaData.getWriteReplaceMethod().invoke(obj, EMPTY_OBJECT_ARRAY);
                    if (obj != null && obj != orig && obj.getClass() != metaData.getClazz()) {
                        if (isDebug) {
                            log.debug((Object)("originalObject=" + orig.getClass().getName() + " substituted by " + obj.getClass().getName()));
                        }
                        ObjectDescriptorFactory.describeObject(cache, obj);
                        return;
                    }
                    metaData = ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
                }
                catch (Exception e) {
                    IOException io = new IOException("Metadata Serialization Error");
                    io.initCause(e);
                    throw io;
                }
            }
        }
        if (cache.getSubstitution() != null) {
            if (isDebug) {
                log.debug((Object)"describeObject::checking substitution on interface");
            }
            orig = obj;
            obj = cache.getSubstitution().replaceObject(obj);
            if (obj != null && obj != orig && obj.getClass() != metaData.getClazz()) {
                if (isDebug) {
                    log.debug((Object)("describeObject::on check interface, original object[" + orig.getClass().getName() + "] was replaced by [" + obj.getClass().getName() + "]"));
                }
                ObjectDescriptorFactory.describeObject(cache, obj);
                return;
            }
        }
        int description = 0;
        if (cache.getSafeToReuse() != null && (description = cache.getSafeToReuse().storeSafe(obj)) != 0) {
            if (isDebug) {
                log.debug((Object)("describeObject::a safeClone reference " + description));
            }
            outputParent.writeByte(50);
            cache.getOutput().addObjectReference(description);
            return;
        }
        description = cache.findIdInCacheWrite(obj);
        if (description != 0) {
            if (isDebug) {
                log.debug((Object)("describeObject::a circular reference " + description));
            }
            outputParent.writeByte(3);
            cache.getOutput().addObjectReference(description);
            return;
        }
        description = cache.putObjectInCacheWrite(obj);
        if (isDebug) {
            log.debug((Object)("describeObject::a new reference " + description));
        }
        outputParent.writeByte(51);
        cache.getOutput().addObjectReference(description);
        int cacheId = cache.findIdInCacheWrite(metaData);
        if (cacheId == 0) {
            cacheId = cache.putObjectInCacheWrite(metaData);
            outputParent.writeByte(51);
            outputParent.addObjectReference(cacheId);
            StreamingClass.saveStream(metaData, outputParent);
        } else {
            outputParent.writeByte(3);
            outputParent.addObjectReference(cacheId);
        }
        Persister persister = PersistResolver.resolvePersister(obj, metaData);
        outputParent.writeByte(persister.getId());
        persister.writeData(metaData, cache.getOutput(), obj, cache.getSubstitution());
    }

    private static Object readObjectDescriptionFromStreaming(ObjectsCache cache, int reference, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        int referenceId;
        byte defClass = input.readByte();
        StreamingClass streamingClass = null;
        if (defClass == 51) {
            referenceId = input.readObjectReference();
            streamingClass = StreamingClass.readStream(input, cache.getClassResolver(), cache.getLoader());
            cache.putObjectInCacheRead(referenceId, streamingClass);
        } else {
            referenceId = input.readObjectReference();
            streamingClass = (StreamingClass)cache.findObjectInCacheRead(referenceId);
            if (streamingClass == null) {
                throw new IOException("Didn't find StreamingClass circular refernce id=" + referenceId);
            }
        }
        ClassMetaData metaData = streamingClass.getMetadata();
        if (isDebug) {
            log.debug((Object)("Reading object for id=" + reference + " classLoader=" + cache.getLoader() + " className = " + metaData.getClassName()));
        }
        byte persisterId = input.readByte();
        Persister persister = PersistResolver.resolvePersister(persisterId);
        Object value = persister.readData(cache.getLoader(), streamingClass, metaData, reference, cache, cache.getInput(), cache.getSubstitution());
        if (!(persister instanceof ClassReferencePersister)) {
            if (cache.getSubstitution() != null) {
                value = cache.getSubstitution().replaceObject(value);
            }
            try {
                if (metaData.getReadResolveMethod() != null) {
                    if (isDebug) {
                        log.debug((Object)("readObjectDescriptionFromStreaming::calling readResolve for className = " + metaData.getClassName()));
                    }
                    value = metaData.getReadResolveMethod().invoke(value, new Object[0]);
                    cache.reassignObjectInCacheRead(reference, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            catch (InvocationTargetException e) {
                throw new SerializationException(e);
            }
        }
        return value;
    }
}

