/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.serial.classmetamodel.ClassResolver;
import org.jboss.serial.objectmetamodel.DataExport;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import org.jboss.serial.util.ClassMetaConsts;
import org.jboss.serial.util.StringUtilBuffer;

public class ObjectsCache
extends DataExport
implements ClassMetaConsts {
    final TObjectIntHashMap objectsCacheOnWrite = new TObjectIntHashMap(identityHashStrategy);
    final TIntObjectHashMap objectsCacheOnRead = new TIntObjectHashMap();
    ObjectSubstitutionInterface substitution;
    ClassLoader loader = null;
    boolean checkSerializableClass = true;
    SafeCloningRepository safeToReuse;
    JBossSeralizationOutputInterface output;
    JBossSeralizationInputInterface input;
    StringUtilBuffer stringBuffer;
    ClassResolver resolver;

    public ObjectsCache cloneCache() {
        ObjectsCache newCache = new ObjectsCache();
        newCache.substitution = this.substitution;
        newCache.loader = this.loader;
        newCache.checkSerializableClass = this.checkSerializableClass;
        newCache.safeToReuse = this.safeToReuse;
        newCache.resolver = this.resolver;
        newCache.stringBuffer = null;
        return newCache;
    }

    private ObjectsCache() {
    }

    public ObjectsCache(ObjectSubstitutionInterface substitution, ClassLoader loader, SafeCloningRepository safeToReuse, boolean checkSerializableClass, StringUtilBuffer stringBuffer) {
        this.loader = loader;
        this.substitution = substitution;
        this.checkSerializableClass = checkSerializableClass;
        this.safeToReuse = safeToReuse;
        this.stringBuffer = stringBuffer;
    }

    public void reset() {
        if (this.safeToReuse != null) {
            this.safeToReuse.clear();
        }
        this.objectsCacheOnWrite.clear();
        this.objectsCacheOnRead.clear();
    }

    public ClassLoader getLoader() {
        if (this.loader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ObjectSubstitutionInterface getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(ObjectSubstitutionInterface substitution) {
        this.substitution = substitution;
    }

    public StringUtilBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public void setStringBuffer(StringUtilBuffer stringBuffer) {
        this.stringBuffer = stringBuffer;
    }

    public int findIdInCacheWrite(Object obj) {
        return this.objectsCacheOnWrite.get(obj);
    }

    public Object findObjectInCacheRead(int key) {
        return this.objectsCacheOnRead.get(key);
    }

    public void putObjectInCacheRead(int key, Object obj) {
        this.objectsCacheOnRead.put(key, obj);
    }

    public void reassignObjectInCacheRead(int key, Object value) {
        this.objectsCacheOnRead.remove(key);
        this.putObjectInCacheRead(key, value);
    }

    public int putObjectInCacheWrite(Object obj) {
        this.objectsCacheOnWrite.put(obj, this.objectsCacheOnWrite.size() + 1);
        return this.objectsCacheOnWrite.size();
    }

    public SafeCloningRepository getSafeToReuse() {
        return this.safeToReuse;
    }

    public boolean isCheckSerializableClass() {
        return this.checkSerializableClass;
    }

    public void setCheckSerializableClass(boolean checkSerializableClass) {
        this.checkSerializableClass = checkSerializableClass;
    }

    public JBossSeralizationOutputInterface getOutput() {
        return this.output;
    }

    public void setOutput(JBossSeralizationOutputInterface output) {
        this.output = output;
    }

    public JBossSeralizationInputInterface getInput() {
        return this.input;
    }

    public void setInput(JBossSeralizationInputInterface input) {
        this.input = input;
    }

    public ClassResolver getClassResolver() {
        return this.resolver;
    }

    public void setClassResolver(ClassResolver resolver) {
        this.resolver = resolver;
    }

    public static interface JBossSeralizationInputInterface
    extends ObjectInput {
        public int readObjectReference() throws IOException;

        public byte readByteDirectly() throws IOException;

        public Object readImmutable(byte var1, ObjectsCache var2) throws IOException;
    }

    public static interface JBossSeralizationOutputInterface
    extends ObjectOutput {
        public void addObjectReference(int var1) throws IOException;

        public void openObjectDefinition() throws IOException;

        public void closeObjectDefinition() throws IOException;

        public void writeByteDirectly(byte var1) throws IOException;

        public boolean isCheckSerializableClass();

        public void saveImmutable(ObjectsCache var1, Object var2) throws IOException;
    }
}

