/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.util.collection.WeakValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeakTypeCache<T> {
    private Map<ClassLoader, Map<String, T>> cache = new WeakHashMap<ClassLoader, Map<String, T>>();

    public T get(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return this.getClass((Class)type);
        }
        if (type instanceof TypeVariable) {
            return this.getTypeVariable((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return this.getGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.getWildcardType((WildcardType)type);
        }
        throw new UnsupportedOperationException("Unknown type: " + type + " class=" + type.getClass());
    }

    public T get(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = cl.loadClass(name);
        return this.get(clazz);
    }

    protected abstract T instantiate(Class<?> var1);

    protected abstract void generate(Class<?> var1, T var2);

    protected abstract T instantiate(ParameterizedType var1);

    protected abstract void generate(ParameterizedType var1, T var2);

    protected T getParameterizedType(ParameterizedType type) {
        T result = this.peek(type);
        if (result != null) {
            return result;
        }
        result = this.instantiate(type);
        this.put(type, result);
        this.generate(type, result);
        return result;
    }

    protected T getWildcardType(WildcardType type) {
        return this.get(type.getUpperBounds()[0]);
    }

    protected <D extends GenericDeclaration> T getTypeVariable(TypeVariable<D> type) {
        return this.get(type.getBounds()[0]);
    }

    protected T getGenericArrayType(GenericArrayType type) {
        return this.get((Type)((Object)Object[].class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T peek(ParameterizedType type) {
        Map<String, T> classLoaderCache;
        Class rawType = (Class)type.getRawType();
        Map<String, T> map = classLoaderCache = this.getClassLoaderCache(rawType.getClassLoader());
        synchronized (map) {
            return classLoaderCache.get(type.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(ParameterizedType type, T result) {
        Map<String, T> classLoaderCache;
        Class rawType = (Class)type.getRawType();
        Map<String, T> map = classLoaderCache = this.getClassLoaderCache(rawType.getClassLoader());
        synchronized (map) {
            classLoaderCache.put(type.toString(), result);
        }
    }

    protected T getClass(Class<?> clazz) {
        T result = this.peek(clazz);
        if (result != null) {
            return result;
        }
        result = this.instantiate(clazz);
        this.put(clazz, result);
        this.generate(clazz, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T peek(Class<?> clazz) {
        Map<String, T> classLoaderCache;
        Map<String, T> map = classLoaderCache = this.getClassLoaderCache(clazz.getClassLoader());
        synchronized (map) {
            return classLoaderCache.get(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(Class<?> clazz, T result) {
        Map<String, T> classLoaderCache;
        Map<String, T> map = classLoaderCache = this.getClassLoaderCache(clazz.getClassLoader());
        synchronized (map) {
            classLoaderCache.put(clazz.getName(), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, T> getClassLoaderCache(ClassLoader cl) {
        Map<ClassLoader, Map<String, T>> map = this.cache;
        synchronized (map) {
            Map<String, T> result = this.cache.get(cl);
            if (result == null) {
                result = new WeakValueHashMap<String, T>();
                this.cache.put(cl, result);
            }
            return result;
        }
    }
}

