/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarUtils {
    private static Set<String> jarSuffixes = new CopyOnWriteArraySet<String>();

    public static void setJarSuffixes(Set<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        jarSuffixes = suffixes;
    }

    public static boolean addJarSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return jarSuffixes.add(suffix);
    }

    public static boolean removeJarSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return jarSuffixes.remove(suffix);
    }

    public static Set<String> getSuffixes() {
        return jarSuffixes;
    }

    public static void clearSuffixes() {
        jarSuffixes.clear();
    }

    private JarUtils() {
    }

    public static boolean isArchive(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String suffix = name.substring(index);
        return jarSuffixes.contains(suffix);
    }

    public static URL createJarURL(URL url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        return new URL("jar:" + url + "!/");
    }

    static {
        jarSuffixes.add(".zip");
        jarSuffixes.add(".ear");
        jarSuffixes.add(".jar");
        jarSuffixes.add(".rar");
        jarSuffixes.add(".war");
        jarSuffixes.add(".sar");
        jarSuffixes.add(".har");
        jarSuffixes.add(".aop");
    }
}

