/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.memory;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.memory.MemoryContextHandler;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.VirtualFileHandler;

public class MemoryContext
extends AbstractVFSContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MemoryContextHandler root;
    private final VirtualFile rootFile;

    protected MemoryContext(URL url) throws URISyntaxException {
        super(url);
        this.root = new MemoryContextHandler(this, null, url, url.getFile());
        this.rootFile = this.root.getVirtualFile();
    }

    public VirtualFileHandler getRoot() throws IOException {
        return this.root;
    }

    VirtualFileHandler createDirectory(URL url) {
        return this.putFile(url, null);
    }

    VirtualFileHandler putFile(URL url, byte[] contents) {
        try {
            String[] tokens = PathTokenizer.getTokens(url.getPath());
            if (tokens == null || tokens.length == 0) {
                return null;
            }
            boolean definitelyNew = false;
            String protocolAndHost = url.getProtocol() + "://" + url.getHost();
            StringBuffer path = new StringBuffer(protocolAndHost);
            MemoryContextHandler current = this.root;
            for (int i = 0; i < tokens.length; ++i) {
                path.append("/");
                path.append(tokens[i]);
                if (!definitelyNew) {
                    try {
                        MemoryContextHandler child = current.getDirectChild(tokens[i]);
                        if (child != null) {
                            current = child;
                            continue;
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    definitelyNew = true;
                }
                URL localUrl = new URL(path.toString());
                if (current.getContents() != null) {
                    throw new IllegalStateException("Cannot add a child to " + current + " it already has contents");
                }
                current = new MemoryContextHandler(this, current, localUrl, tokens[i]);
            }
            current.setContents(contents);
            return current;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

