/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLFeature;
import org.jboss.ws.metadata.wsdl.WSDLProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Extendable
implements Serializable {
    private Logger log = Logger.getLogger(this.getClass());
    private Map features = new LinkedHashMap();
    private Map properties = new LinkedHashMap();
    private Map<String, List<WSDLExtensibilityElement>> extElements = new LinkedHashMap<String, List<WSDLExtensibilityElement>>();

    public WSDLFeature[] getFeatures() {
        WSDLFeature[] arr = new WSDLFeature[this.features.size()];
        new ArrayList(this.features.values()).toArray(arr);
        return arr;
    }

    public void addFeature(WSDLFeature feature) {
        this.log.trace("addFeature: " + feature);
        String uri = feature.getURI();
        this.features.put(uri, feature);
    }

    public WSDLFeature getFeature(String uri) {
        WSDLFeature feature = (WSDLFeature)this.features.get(uri);
        return feature;
    }

    public WSDLProperty[] getProperties() {
        WSDLProperty[] arr = new WSDLProperty[this.properties.size()];
        new ArrayList(this.properties.values()).toArray(arr);
        return arr;
    }

    public void addProperty(WSDLProperty property) {
        this.log.trace("addProperty: " + property);
        String uri = property.getURI();
        this.properties.put(uri, property);
    }

    public WSDLProperty getProperty(String uri) {
        WSDLProperty property = (WSDLProperty)this.properties.get(uri);
        return property;
    }

    public void addExtensibilityElement(WSDLExtensibilityElement extElement) {
        this.log.trace("addExtensibilityElement: " + extElement);
        String uri = extElement.getUri();
        List<WSDLExtensibilityElement> list2 = this.extElements.get(uri);
        if (list2 == null) {
            list2 = new LinkedList<WSDLExtensibilityElement>();
            this.extElements.put(uri, list2);
        }
        list2.add(extElement);
    }

    public List<WSDLExtensibilityElement> getExtensibilityElements(String uri) {
        ArrayList list2 = this.extElements.get(uri);
        return list2 == null ? new ArrayList() : list2;
    }

    public List<WSDLExtensibilityElement> getAllExtensibilityElements() {
        LinkedList<WSDLExtensibilityElement> list2 = new LinkedList<WSDLExtensibilityElement>();
        for (String k : this.extElements.keySet()) {
            list2.addAll((Collection<WSDLExtensibilityElement>)this.extElements.get(k));
        }
        return list2;
    }
}

