/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.junit;

import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.kernel.junit.MicrocontainerTestDelegate;

public class AOPMicrocontainerTestDelegate
extends MicrocontainerTestDelegate {
    private static final CopyOnWriteArrayList urls = new CopyOnWriteArrayList();

    public AOPMicrocontainerTestDelegate(Class clazz) throws Exception {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.log.debug("Security enabled: " + this.enableSecurity);
    }

    protected void deploy() throws Exception {
        String testName = this.clazz.getName();
        testName = testName.replace('.', '/') + "-aop.xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deployAOP(url);
        } else {
            this.log.debug("No test specific deployment " + testName);
        }
        super.deploy();
    }

    protected void undeploy() {
        super.undeploy();
        for (URL url : urls) {
            this.undeployAOP(url);
        }
    }

    protected void deployAOP(URL url) throws Exception {
        this.log.debug("Deploying " + url);
        urls.add(url);
        AspectXmlLoader.deployXML(url);
    }

    protected void undeployAOP(URL url) {
        try {
            this.log.debug("Undeploying " + url);
            urls.remove(url);
            AspectXmlLoader.undeployXML(url);
        }
        catch (Exception e) {
            this.log.warn("Ignored error undeploying " + url, e);
        }
    }
}

