/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.jboss.aop.Advised;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.ForwardingInterceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.NotRegisteredException;
import org.jboss.aspects.remoting.ReplicantsManagerInterceptor;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class ClusteredRemoting
implements ClusterConstants {
    private static final Logger log = Logger.getLogger(ClusteredRemoting.class);

    public static ClassProxy clusterObject(Object objectId, Object obj, String partitionName, LoadBalancePolicy lb, InvokerLocator locator) throws Exception {
        ClassProxy proxy;
        Class<?> clazz;
        String proxyFamilyName = objectId.toString() + locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)new InitialContext().lookup("/HAPartition/" + partitionName);
        HATarget target = null;
        HashMap<String, HATarget> families = null;
        InstanceAdvisor advisor = null;
        if (obj instanceof Advised) {
            advisor = ((Advised)obj)._getInstanceAdvisor();
            clazz = obj.getClass();
            Dispatcher.singleton.registerTarget(objectId, obj);
        } else {
            clazz = obj.getClass();
            proxy = ClassProxyFactory.newInstance(obj.getClass());
            advisor = proxy._getInstanceAdvisor();
            advisor.insertInterceptor(new ForwardingInterceptor(obj));
            Dispatcher.singleton.registerTarget(objectId, proxy);
        }
        families = (HashMap<String, HATarget>)advisor.getMetaData().getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILIES");
        if (families != null) {
            target = (HATarget)families.get(proxyFamilyName);
            if (target == null) {
                target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
                ClusteringTargetsRepository.initTarget(proxyFamilyName, target.getReplicants());
                families.put(proxyFamilyName, target);
            }
        } else {
            families = new HashMap<String, HATarget>();
            target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
            ClusteringTargetsRepository.initTarget(proxyFamilyName, target.getReplicants());
            families.put(proxyFamilyName, target);
            advisor.insertInterceptor(0, new ReplicantsManagerInterceptor(families));
        }
        proxy = ClassProxyFactory.newInstance(clazz);
        InstanceAdvisor proxyAdvisor = proxy._getInstanceAdvisor();
        proxyAdvisor.insertInterceptor(IsLocalInterceptor.singleton);
        advisor.insertInterceptor(SecurityClientInterceptor.singleton);
        advisor.insertInterceptor(ClientTxPropagationInterceptor.singleton);
        proxyAdvisor.insertInterceptor(MergeMetaDataInterceptor.singleton);
        proxyAdvisor.insertInterceptor(ClusterChooserInterceptor.singleton);
        proxyAdvisor.insertInterceptor(InvokeRemoteInterceptor.singleton);
        proxyAdvisor.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER", new FamilyWrapper(proxyFamilyName, target.getReplicants()), PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY", lb, PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData("DISPATCHER", "OID", objectId, PayloadKey.AS_IS);
        return proxy;
    }

    public static void unregisterClusteredObject(Object object) {
        try {
            ClassProxy proxy = (ClassProxy)object;
            InstanceAdvisor advisor = proxy._getInstanceAdvisor();
            String oid = (String)advisor.getMetaData().getMetaData("DISPATCHER", "OID");
            InstanceAdvised registeredObject = (InstanceAdvised)Dispatcher.singleton.getRegistered(oid);
            if (registeredObject == null) {
                throw new NotRegisteredException(oid.toString() + " is not registered");
            }
            Dispatcher.singleton.unregisterTarget(oid);
            advisor = registeredObject._getInstanceAdvisor();
            Map families = (Map)advisor.getMetaData().getMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILIES");
            for (HATarget target : families.values()) {
                target.destroy();
            }
        }
        catch (Exception ignored) {
            log.trace("Ignored exception unregistering a clustered object", ignored);
        }
    }
}

