/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class ControllerMode
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ControllerMode AUTOMATIC = new ControllerMode("Automatic");
    public static final ControllerMode ON_DEMAND = new ControllerMode("On Demand");
    public static final ControllerMode MANUAL = new ControllerMode("Manual");
    public static final ControllerMode DISABLED = new ControllerMode("Disabled");
    protected final String modeString;
    private static Map<String, ControllerMode> values = new HashMap<String, ControllerMode>();

    public ControllerMode(String modeString) {
        if (modeString == null) {
            throw new IllegalArgumentException("Null mode string");
        }
        this.modeString = modeString;
    }

    public String getModeString() {
        return this.modeString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ControllerMode)) {
            return false;
        }
        ControllerMode other = (ControllerMode)object;
        return this.modeString.equals(other.modeString);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.modeString);
    }

    protected int getHashCode() {
        return this.modeString.hashCode();
    }

    protected Object readResolve() throws ObjectStreamException {
        return values.get(this.modeString);
    }

    static {
        values.put(AUTOMATIC.getModeString(), AUTOMATIC);
        values.put(ON_DEMAND.getModeString(), ON_DEMAND);
        values.put(MANUAL.getModeString(), MANUAL);
        values.put(DISABLED.getModeString(), DISABLED);
    }
}

