/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.classloading.helpers;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.ModuleCapability;
import org.jboss.deployers.structure.spi.classloading.RequireModule;
import org.jboss.deployers.structure.spi.classloading.Requirement;
import org.jboss.deployers.structure.spi.classloading.Version;

public class ModuleCapabilityImpl
implements ModuleCapability {
    private static final long serialVersionUID = -5444212755644141118L;
    private String name;
    private Version version;

    public ModuleCapabilityImpl(String name) {
        this(name, null);
    }

    public ModuleCapabilityImpl(String name, Version version) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean resolves(DeploymentUnit unit, Requirement requirement) {
        if (!(requirement instanceof RequireModule)) {
            return false;
        }
        RequireModule requireModule = (RequireModule)requirement;
        if (!this.getName().equals(requireModule.getName())) {
            return false;
        }
        return requireModule.getVersionRange().isInRange(this.getVersion());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ModuleCapability)) {
            return false;
        }
        ModuleCapability other = (ModuleCapability)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getVersion().equals(other.getVersion());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "Module: " + this.getName() + ":" + this.getVersion();
    }
}

