/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.virtual.VirtualFile;

public class SecurityActions {
    static InputStream openStream(VirtualFile f) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return FileActions.PRIVILEGED.openStream(f);
        }
        return FileActions.NON_PRIVILEGED.openStream(f);
    }

    static interface FileActions {
        public static final FileActions PRIVILEGED = new FileActions(){

            public InputStream openStream(final VirtualFile f) throws IOException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            return f.openStream();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final FileActions NON_PRIVILEGED = new FileActions(){

            public InputStream openStream(VirtualFile f) throws IOException {
                return f.openStream();
            }
        };

        public InputStream openStream(VirtualFile var1) throws IOException;
    }
}

