/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.rmi.RemoteException;
import java.security.Identity;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.SecurityActions;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.integration.ejb.EJBAuthorizationHelper;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;

public abstract class EnterpriseContext
implements AllowedOperationsFlags {
    protected static Logger log = Logger.getLogger(EnterpriseContext.class);
    Object instance;
    Container con;
    Synchronization synch;
    Transaction transaction;
    private Principal principal;
    private Principal beanPrincipal;
    private SecurityContext securityContext;
    Object id;
    int locked = 0;
    Object txLock = new Object();
    private Stack inMethodStack = new Stack();
    private static ServerVMClientUserTransaction.UserTransactionStartedListener tsl;

    public static void setUserTransactionStartedListener(ServerVMClientUserTransaction.UserTransactionStartedListener newTsl) {
        tsl = newTsl;
    }

    public EnterpriseContext(Object instance, Container con) {
        this.instance = instance;
        this.con = con;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Container getContainer() {
        return this.con;
    }

    public abstract void discard() throws RemoteException;

    public abstract EJBContext getEJBContext();

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public Object getTxLock() {
        return this.txLock;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
        this.beanPrincipal = null;
        if (this.con.getSecurityManager() != null) {
            this.beanPrincipal = this.getCallerPrincipal();
        }
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void lock() {
        ++this.locked;
    }

    public void unlock() {
        --this.locked;
        if (this.locked < 0) {
            log.error("locked < 0", new Throwable());
        }
    }

    public boolean isLocked() {
        return this.locked != 0;
    }

    public Principal getCallerPrincipal() {
        EJBContextImpl ctxImpl = (EJBContextImpl)this.getEJBContext();
        return ctxImpl.getCallerPrincipalInternal();
    }

    public void clear() {
        this.id = null;
        this.locked = 0;
        this.principal = null;
        this.beanPrincipal = null;
        this.synch = null;
        this.transaction = null;
        this.inMethodStack.clear();
    }

    protected boolean isContainerManagedTx() {
        BeanMetaData md = this.con.getBeanMetaData();
        return md.isContainerManagedTx();
    }

    protected boolean isUserManagedTx() {
        BeanMetaData md = this.con.getBeanMetaData();
        return !md.isContainerManagedTx();
    }

    protected class UserTransactionImpl
    implements UserTransaction {
        private int timeout = 0;
        boolean trace = log.isTraceEnabled();

        public UserTransactionImpl() {
            if (this.trace) {
                log.trace("new UserTx: " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void begin() throws NotSupportedException, SystemException {
            TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
            int oldTimeout = -1;
            if (tm instanceof TransactionTimeoutConfiguration) {
                oldTimeout = ((TransactionTimeoutConfiguration)((Object)tm)).getTransactionTimeout();
            }
            tm.setTransactionTimeout(this.timeout);
            try {
                tm.begin();
                if (tsl != null) {
                    tsl.userTransactionStarted();
                }
                Transaction tx = tm.getTransaction();
                if (this.trace) {
                    log.trace("UserTx begin: " + tx);
                }
                EnterpriseContext.this.setTransaction(tx);
                Object var5_4 = null;
                if (oldTimeout == -1) return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (oldTimeout == -1) throw throwable;
                tm.setTransactionTimeout(oldTimeout);
                throw throwable;
            }
            tm.setTransactionTimeout(oldTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
            try {
                Transaction tx = tm.getTransaction();
                if (this.trace) {
                    log.trace("UserTx commit: " + tx);
                }
                int status = tm.getStatus();
                tm.commit();
                Object var5_4 = null;
                EnterpriseContext.this.setTransaction(null);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                EnterpriseContext.this.setTransaction(null);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
            try {
                Transaction tx = tm.getTransaction();
                if (this.trace) {
                    log.trace("UserTx rollback: " + tx);
                }
                tm.rollback();
                Object var4_3 = null;
                EnterpriseContext.this.setTransaction(null);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                EnterpriseContext.this.setTransaction(null);
                throw throwable;
            }
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
            Transaction tx = tm.getTransaction();
            if (this.trace) {
                log.trace("UserTx setRollbackOnly: " + tx);
            }
            tm.setRollbackOnly();
        }

        public int getStatus() throws SystemException {
            TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
            return tm.getStatus();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.timeout = seconds;
        }
    }

    protected class EJBContextImpl
    implements EJBContext {
        private UserTransactionImpl userTransaction = null;
        private InitialContext ctx;

        private InitialContext getContext() {
            if (this.ctx == null) {
                try {
                    this.ctx = new InitialContext();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.ctx;
        }

        protected EJBContextImpl() {
        }

        public Object lookup(String name) {
            try {
                return this.getContext().lookup(name);
            }
            catch (NamingException namingException) {
                return null;
            }
        }

        public Identity getCallerIdentity() {
            throw new EJBException("Deprecated");
        }

        public TimerService getTimerService() throws IllegalStateException {
            return EnterpriseContext.this.getContainer().getTimerService(null);
        }

        public Principal getCallerPrincipal() {
            return this.getCallerPrincipalInternal();
        }

        Principal getCallerPrincipalInternal() {
            if (EnterpriseContext.this.beanPrincipal == null) {
                RealmMapping rm = EnterpriseContext.this.con.getRealmMapping();
                EJBAuthorizationHelper helper = new EJBAuthorizationHelper(EnterpriseContext.this.securityContext);
                Principal caller = helper.getCallerPrincipal(rm);
                if (caller == null) {
                    if (EnterpriseContext.this.principal != null) {
                        caller = rm != null ? rm.getPrincipal(EnterpriseContext.this.principal) : EnterpriseContext.this.principal;
                    } else {
                        ApplicationMetaData appMetaData = EnterpriseContext.this.con.getBeanMetaData().getApplicationMetaData();
                        String name = appMetaData.getUnauthenticatedPrincipal();
                        if (name != null) {
                            caller = new SimplePrincipal(name);
                        }
                    }
                }
                if (caller == null) {
                    throw new IllegalStateException("No valid security context for the caller identity");
                }
                EnterpriseContext.this.beanPrincipal = caller;
            }
            return EnterpriseContext.this.beanPrincipal;
        }

        public EJBHome getEJBHome() {
            EJBProxyFactory proxyFactory = EnterpriseContext.this.con.getProxyFactory();
            if (proxyFactory == null) {
                throw new IllegalStateException("No remote home defined.");
            }
            return (EJBHome)proxyFactory.getEJBHome();
        }

        public EJBLocalHome getEJBLocalHome() {
            if (EnterpriseContext.this.con.getLocalHomeClass() == null) {
                throw new IllegalStateException("No local home defined.");
            }
            if (EnterpriseContext.this.con instanceof EntityContainer) {
                return ((EntityContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
            }
            if (EnterpriseContext.this.con instanceof StatelessSessionContainer) {
                return ((StatelessSessionContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
            }
            if (EnterpriseContext.this.con instanceof StatefulSessionContainer) {
                return ((StatefulSessionContainer)EnterpriseContext.this.con).getLocalProxyFactory().getEJBLocalHome();
            }
            throw new EJBException("No EJBLocalHome available (BUG!)");
        }

        public Properties getEnvironment() {
            throw new EJBException("Deprecated");
        }

        public boolean getRollbackOnly() {
            if (EnterpriseContext.this.con.getBeanMetaData().isBeanManagedTx()) {
                throw new IllegalStateException("getRollbackOnly() not allowed for BMT beans.");
            }
            try {
                TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
                if (tm.getTransaction() == null) {
                    throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
                }
                int status = tm.getStatus();
                return status == 1 || status == 9 || status == 4;
            }
            catch (SystemException e) {
                log.warn("failed to get tx manager status; ignoring", e);
                return true;
            }
        }

        public void setRollbackOnly() {
            if (EnterpriseContext.this.con.getBeanMetaData().isBeanManagedTx()) {
                throw new IllegalStateException("setRollbackOnly() not allowed for BMT beans.");
            }
            try {
                TransactionManager tm = EnterpriseContext.this.con.getTransactionManager();
                if (tm.getTransaction() == null) {
                    throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
                }
                tm.setRollbackOnly();
            }
            catch (SystemException e) {
                log.warn("failed to set rollback only; ignoring", e);
            }
        }

        public boolean isCallerInRole(Identity id) {
            throw new EJBException("Deprecated");
        }

        public boolean isCallerInRole(String roleName) {
            HashSet<SecurityRoleRef> securityRoleRefs;
            block4: {
                Iterator<SecurityRoleRefMetaData> it = EnterpriseContext.this.getContainer().getBeanMetaData().getSecurityRoleReferences();
                securityRoleRefs = new HashSet<SecurityRoleRef>();
                while (it.hasNext()) {
                    SecurityRoleRefMetaData meta = it.next();
                    securityRoleRefs.add(new SecurityRoleRef(meta.getName(), meta.getLink(), meta.getDescription()));
                }
                Subject contextSubject = null;
                try {
                    contextSubject = SecurityActions.getContextSubject();
                    if (contextSubject == null) {
                        log.error("Subject is null for isCallerInRole Check with role=" + roleName);
                    }
                }
                catch (PolicyContextException pe) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace("PolicyContextException in getting caller subject:", pe);
                }
            }
            EJBAuthorizationHelper helper = new EJBAuthorizationHelper(EnterpriseContext.this.securityContext);
            String ejbName = EnterpriseContext.this.getContainer().getBeanMetaData().getEjbName();
            return helper.isCallerInRole(roleName, ejbName, EnterpriseContext.this.principal, securityRoleRefs);
        }

        public UserTransaction getUserTransaction() {
            if (this.userTransaction == null) {
                if (EnterpriseContext.this.isContainerManagedTx()) {
                    throw new IllegalStateException("CMT beans are not allowed to get a UserTransaction");
                }
                this.userTransaction = new UserTransactionImpl();
            }
            return this.userTransaction;
        }
    }
}

