/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractTxInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.tm.TxUtils;

abstract class AbstractTxInterceptorBMT
extends AbstractTxInterceptor {
    private ThreadLocal userTransaction = new ThreadLocal();
    protected boolean stateless = true;

    AbstractTxInterceptorBMT() {
    }

    public void create() throws Exception {
        super.create();
        RefAddr refAddr = new RefAddr("userTransaction"){
            private static final long serialVersionUID = -8228448967597474960L;

            public Object getContent() {
                return AbstractTxInterceptorBMT.this.userTransaction;
            }
        };
        Reference ref = new Reference("javax.transaction.UserTransaction", refAddr, new UserTxFactory().getClass().getName(), null);
        ((Context)new InitialContext().lookup("java:comp/")).bind("UserTransaction", (Object)ref);
    }

    public void stop() {
        try {
            ((Context)new InitialContext().lookup("java:comp/")).unbind("UserTransaction");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected Object invokeNext(Invocation mi) throws Exception {
        Transaction oldTransaction = mi.getTransaction();
        Object oldUserTx = this.userTransaction.get();
        Transaction threadTx = this.tm.suspend();
        try {
            Object object;
            EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_INTERCEPTOR_METHOD);
                this.userTransaction.set(ctx.getEJBContext().getUserTransaction());
                object = null;
                AllowedOperationsAssociation.popInMethodFlag();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                throw throwable;
            }
            Transaction beanTx = ctx.getTransaction();
            if (beanTx != null) {
                this.tm.resume(beanTx);
            }
            mi.setTransaction(beanTx);
            try {
                object = super.invokeNext(mi, false);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var11_15 = null;
                    this.tm.suspend();
                    throw throwable2;
                }
                if (this.stateless) {
                    this.checkStatelessDone();
                } else {
                    this.checkBadStateful();
                }
                Object var11_14 = null;
                this.tm.suspend();
                throw throwable;
            }
            try {
                if (this.stateless) {
                    this.checkStatelessDone();
                } else {
                    this.checkBadStateful();
                }
                Object var11_12 = null;
                this.tm.suspend();
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.tm.suspend();
                throw throwable;
            }
            Object var13_18 = null;
            this.userTransaction.set(oldUserTx);
            mi.setTransaction(oldTransaction);
            if (threadTx == null) return object;
            this.tm.resume(threadTx);
            return object;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            this.userTransaction.set(oldUserTx);
            mi.setTransaction(oldTransaction);
            if (threadTx == null) throw throwable;
            this.tm.resume(threadTx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatelessDone() throws RemoteException {
        Transaction tx2;
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error("Failed to get status", ex);
        }
        try {
            switch (status) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: {
                    try {
                        this.tm.rollback();
                    }
                    catch (Exception ex) {
                        this.log.error("Failed to rollback", ex);
                    }
                }
                case 2: {
                    String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
                    this.log.error(msg);
                    throw new RemoteException(msg);
                }
            }
            Object var4_5 = null;
            tx2 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Transaction tx2 = null;
            try {
                tx2 = this.tm.suspend();
            }
            catch (SystemException ex) {
                this.log.error("Failed to suspend transaction", ex);
            }
            if (tx2 != null) {
                String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before " + " returning (ejb1.1 spec, 11.6.1), suspended tx=" + tx2;
                this.log.error(msg);
                throw new RemoteException(msg);
            }
            throw throwable;
        }
        try {
            tx2 = this.tm.suspend();
        }
        catch (SystemException ex) {
            this.log.error("Failed to suspend transaction", ex);
        }
        if (tx2 != null) {
            String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before " + " returning (ejb1.1 spec, 11.6.1), suspended tx=" + tx2;
            this.log.error(msg);
            throw new RemoteException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBadStateful() throws RemoteException {
        Transaction tx2;
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error("Failed to get status", ex);
        }
        try {
            switch (status) {
                case 1: 
                case 7: 
                case 8: 
                case 9: {
                    try {
                        this.tm.rollback();
                    }
                    catch (Exception ex) {
                        this.log.error("Failed to rollback", ex);
                    }
                    String msg = "BMT stateful bean '" + this.container.getBeanMetaData().getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString(status);
                    this.log.error(msg);
                }
            }
            Object var4_5 = null;
            tx2 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Transaction tx2 = null;
            try {
                tx2 = this.tm.suspend();
            }
            catch (SystemException ex) {
                this.log.error("Failed to suspend transaction", ex);
            }
            if (tx2 != null) {
                String msg = "BMT stateful bean " + this.container.getBeanMetaData().getEjbName() + " did not complete user transaction properly tx=" + tx2;
                this.log.error(msg);
            }
            throw throwable;
        }
        try {
            tx2 = this.tm.suspend();
        }
        catch (SystemException ex) {
            this.log.error("Failed to suspend transaction", ex);
        }
        if (tx2 != null) {
            String msg = "BMT stateful bean " + this.container.getBeanMetaData().getEjbName() + " did not complete user transaction properly tx=" + tx2;
            this.log.error(msg);
        }
    }

    public static class UserTxFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable environment) throws Exception {
            RefAddr refAddr = ((Reference)ref).get(0);
            ThreadLocal threadLocal = (ThreadLocal)refAddr.getContent();
            return threadLocal.get();
        }
    }
}

