/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.quartz;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.jboss.logging.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class TimerImpl
implements Timer {
    private static final Logger log = Logger.getLogger(TimerImpl.class);
    private Scheduler scheduler;
    private Trigger trigger;
    private Serializable info;

    protected TimerImpl(Scheduler scheduler, Trigger trigger, Serializable info) {
        assert (scheduler != null);
        assert (trigger != null);
        this.scheduler = scheduler;
        this.trigger = trigger;
        this.info = info;
    }

    protected void checkState() {
        if (this.trigger.getNextFireTime() == null) {
            throw new NoSuchObjectLocalException("timer has expired");
        }
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkState();
        try {
            this.scheduler.unscheduleJob(this.trigger.getName(), this.trigger.getGroup());
        }
        catch (SchedulerException e) {
            log.error("cancel failed", e);
            throw new EJBException(e.getMessage());
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        return this.getNextTimeout().getTime() - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkState();
        Date nextTimeout = this.trigger.getNextFireTime();
        if (nextTimeout == null) {
            throw new IllegalStateException("trigger does not have a next fire time");
        }
        return nextTimeout;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkState();
        return this.info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkState();
        return null;
    }
}

