/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream;
import org.jboss.invocation.pooled.interfaces.PooledMarshalledInvocation;
import org.jboss.invocation.pooled.interfaces.ServerAddress;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionPropagationContextFactory;

public class PooledInvokerProxy
implements Invoker,
Externalizable {
    private static final Logger log = Logger.getLogger(PooledInvokerProxy.class);
    private static final long serialVersionUID = -1456509931095566410L;
    private static final int WIRE_VERSION = 1;
    protected static TransactionPropagationContextFactory tpcFactory = null;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    public static long usedPooled = 0L;
    private static int inUseCount = 0;
    private static long socketConnectCount = 0L;
    private static long socketCloseCount = 0L;
    public static int MAX_RETRIES = 10;
    protected static final Map connectionPools = new ConcurrentReaderHashMap();
    protected ServerAddress address;
    protected LinkedList pool = null;
    protected int maxPoolSize;
    protected int retryCount = 1;
    private transient boolean trace;

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public static void clearStats() {
        getSocketTime = 0L;
        readTime = 0L;
        writeTime = 0L;
        serializeTime = 0L;
        deserializeTime = 0L;
        usedPooled = 0L;
    }

    public static long getInUseCount() {
        return inUseCount;
    }

    public static long getUsedPooled() {
        return usedPooled;
    }

    public static long getSocketConnectCount() {
        return socketConnectCount;
    }

    public static long getSocketCloseCount() {
        return socketCloseCount;
    }

    public static int getTotalPoolCount() {
        int count = 0;
        for (List pool : connectionPools.values()) {
            if (pool == null) continue;
            count += pool.size();
        }
        return count;
    }

    public long getPoolCount() {
        return this.pool.size();
    }

    public PooledInvokerProxy() {
        this.trace = log.isTraceEnabled();
    }

    public PooledInvokerProxy(ServerAddress sa, int maxPoolSize) {
        this(sa, maxPoolSize, MAX_RETRIES);
    }

    public PooledInvokerProxy(ServerAddress sa, int maxPoolSize, int retryCount) {
        this.address = sa;
        this.maxPoolSize = maxPoolSize;
        this.retryCount = retryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("clearPool, sa: " + sa);
        }
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    Object var9_10;
                    ClientSocket cs = null;
                    try {
                        try {
                            ClientSocket socket;
                            cs = socket = (ClientSocket)thepool.removeFirst();
                            if (trace) {
                                log.trace("Closing, ClientSocket: " + socket);
                            }
                            --socketCloseCount;
                            socket.socket.close();
                        }
                        catch (Exception ignored) {
                            var9_10 = null;
                            if (cs == null) continue;
                            cs.socket = null;
                            continue;
                        }
                        var9_10 = null;
                        if (cs == null) continue;
                        cs.socket = null;
                        continue;
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        if (cs != null) {
                            cs.socket = null;
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        Map map = connectionPools;
        synchronized (map) {
            for (ServerAddress sa : connectionPools.keySet()) {
                PooledInvokerProxy.clearPool(sa);
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof PooledInvokerProxy)) {
            return false;
        }
        return this.address.equals(((PooledInvokerProxy)other).address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        Map map = connectionPools;
        synchronized (map) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
            }
        }
    }

    protected ClientSocket getConnection() throws Exception {
        Socket socket = null;
        ClientSocket cs = null;
        for (int i = 0; i < this.retryCount; ++i) {
            ClientSocket pooled = this.getPooledConnection();
            if (pooled != null) {
                ++usedPooled;
                ++inUseCount;
                return pooled;
            }
            try {
                if (this.trace) {
                    log.trace("Connecting to addr: " + this.address.address + ", port: " + this.address.port + ",clientSocketFactory: " + this.address.clientSocketFactory + ",enableTcpNoDelay: " + this.address.enableTcpNoDelay + ",timeout: " + this.address.timeout);
                }
                socket = this.address.clientSocketFactory != null ? this.address.clientSocketFactory.createSocket(this.address.address, this.address.port) : new Socket(this.address.address, this.address.port);
                ++socketConnectCount;
                if (this.trace) {
                    log.trace("Connected, socket=" + socket);
                }
                socket.setTcpNoDelay(this.address.enableTcpNoDelay);
                cs = new ClientSocket(socket, this.address.timeout);
                ++inUseCount;
                if (!this.trace) break;
                log.trace("New ClientSocket: " + cs + ", usedPooled=" + usedPooled + ", inUseCount=" + inUseCount + ", socketConnectCount=" + socketConnectCount + ", socketCloseCount=" + socketCloseCount);
                break;
            }
            catch (Exception ex) {
                block12: {
                    block11: {
                        if (!(ex instanceof InterruptedIOException) && !(ex instanceof SocketException)) break block11;
                        if (this.trace) {
                            log.trace("Connect failed", ex);
                        }
                        if (i + 1 < this.retryCount) break block12;
                    }
                    throw ex;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        if (cs == null) {
            throw new ConnectException("Failed to obtain a socket, tries=" + this.retryCount);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSocket firstConnection() {
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() > 0) {
                return (ClientSocket)this.pool.removeFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSocket getPooledConnection() {
        ClientSocket socket = null;
        while ((socket = this.firstConnection()) != null) {
            try {
                if (this.trace) {
                    log.trace("Checking pooled socket: " + socket + ", address: " + socket.socket.getLocalSocketAddress());
                }
                boolean ACK = true;
                socket.out.writeByte(1);
                socket.out.flush();
                socket.in.readByte();
                if (this.trace) {
                    log.trace("Using pooled ClientSocket: " + socket + ", usedPooled=" + usedPooled + ", inUseCount=" + inUseCount + ", socketConnectCount=" + socketConnectCount + ", socketCloseCount=" + socketCloseCount);
                }
                return socket;
            }
            catch (Exception ex) {
                Object var5_5;
                if (this.trace) {
                    log.trace("Failed to validate pooled socket: " + socket, ex);
                }
                try {
                    block11: {
                        try {
                            if (socket == null) break block11;
                            --socketCloseCount;
                            socket.socket.close();
                        }
                        catch (Exception exception) {
                            var5_5 = null;
                            if (socket == null) continue;
                            socket.socket = null;
                            continue;
                        }
                    }
                    var5_5 = null;
                    if (socket == null) continue;
                    socket.socket = null;
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    if (socket != null) {
                        socket.socket = null;
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean returnConnection(ClientSocket socket) {
        boolean pooled = false;
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socket);
                --inUseCount;
                pooled = true;
            }
        }
        return pooled;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    public Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Exception {
        boolean trace = log.isTraceEnabled();
        PooledMarshalledInvocation mi = new PooledMarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        Object response = null;
        long start = System.currentTimeMillis();
        ClientSocket socket = this.getConnection();
        long end = System.currentTimeMillis() - start;
        getSocketTime += end;
        if (socket.sessionID != null) {
            mi.setValue("SESSION_ID", socket.sessionID);
            if (trace) {
                log.trace("Added SESSION_ID to invocation");
            }
        }
        try {
            if (trace) {
                log.trace("Sending invocation to: " + mi.getObjectName());
            }
            socket.out.writeObject(mi);
            socket.out.reset();
            socket.out.writeObject(Boolean.TRUE);
            socket.out.flush();
            socket.out.reset();
            end = System.currentTimeMillis() - start;
            writeTime += end;
            start = System.currentTimeMillis();
            response = socket.in.readObject();
            socket.in.readObject();
            end = System.currentTimeMillis() - start;
            readTime += end;
        }
        catch (Exception ex) {
            if (trace) {
                log.trace("Failure during invoke", ex);
            }
            try {
                try {
                    --socketCloseCount;
                    socket.socket.close();
                }
                catch (Exception ignored) {
                    Object var13_12 = null;
                    socket.socket = null;
                }
                Object var13_11 = null;
                socket.socket = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                socket.socket = null;
                throw throwable;
            }
            throw new ConnectException("Failure during invoke", ex);
        }
        if (!this.returnConnection(socket)) {
            if (trace) {
                log.trace("Closing unpooled socket: " + socket);
            }
            try {
                try {
                    --socketCloseCount;
                    socket.socket.close();
                }
                catch (Exception ignored) {
                    Object var15_17 = null;
                    socket.socket = null;
                }
                Object var15_16 = null;
                socket.socket = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                socket.socket = null;
                throw throwable;
            }
        }
        try {
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            if (response instanceof MarshalledObject) {
                return ((MarshalledObject)response).get();
            }
            return response;
        }
        catch (ServerException ex) {
            if (ex.detail instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)ex.detail;
            }
            if (ex.detail instanceof TransactionRolledbackException) {
                throw (TransactionRolledbackException)ex.detail;
            }
            throw ex;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.address);
        out.writeInt(this.maxPoolSize);
        out.writeInt(1);
        out.writeInt(this.retryCount);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.trace = log.isTraceEnabled();
        this.address = (ServerAddress)in.readObject();
        this.maxPoolSize = in.readInt();
        int version = 0;
        try {
            version = in.readInt();
        }
        catch (EOFException e) {
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        switch (version) {
            case 0: {
                this.retryCount = MAX_RETRIES;
                break;
            }
            case 1: {
                this.readVersion1(in);
                break;
            }
        }
        this.initPool();
    }

    private void readVersion1(ObjectInput in) throws IOException {
        this.retryCount = in.readInt();
    }

    protected static class ClientSocket
    implements HandshakeCompletedListener {
        public ObjectOutputStream out;
        public ObjectInputStream in;
        public Socket socket;
        public int timeout;
        public String sessionID;
        private boolean handshakeComplete = false;
        private boolean trace;

        public ClientSocket(Socket socket, int timeout) throws Exception {
            this.socket = socket;
            this.trace = log.isTraceEnabled();
            boolean needHandshake = false;
            if (socket instanceof SSLSocket) {
                SSLSocket ssl = (SSLSocket)socket;
                ssl.addHandshakeCompletedListener(this);
                if (this.trace) {
                    log.trace("Starting SSL handshake");
                }
                needHandshake = true;
                this.handshakeComplete = false;
                ssl.startHandshake();
            }
            socket.setSoTimeout(timeout);
            this.timeout = timeout;
            this.out = new OptimizedObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.out.flush();
            this.in = new OptimizedObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            if (needHandshake) {
                socket.setSoTimeout(1000);
                for (int n = 0; !this.handshakeComplete && n < 60; ++n) {
                    try {
                        int b = this.in.read();
                        continue;
                    }
                    catch (SSLException e) {
                        if (this.trace) {
                            log.trace("Error while waiting for handshake to complete", e);
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        if (!this.trace) continue;
                        log.trace("Handshaked read()", e);
                    }
                }
                if (!this.handshakeComplete) {
                    throw new SSLException("Handshaked failed to complete in 60 seconds");
                }
                socket.setSoTimeout(timeout);
            }
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.handshakeComplete = true;
            byte[] id = event.getSession().getId();
            try {
                this.sessionID = new String(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Failed to create session id using UTF-8, using default", e);
                this.sessionID = new String(id);
            }
            if (this.trace) {
                log.trace("handshakeCompleted, event=" + event + ", sessionID=" + this.sessionID);
            }
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer("ClientSocket@");
            tmp.append(System.identityHashCode(this));
            tmp.append('[');
            tmp.append("socket=");
            tmp.append(this.socket.toString());
            tmp.append(']');
            return tmp.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            if (this.socket != null) {
                if (this.trace) {
                    log.trace("Closing socket in finalize: " + this.socket);
                }
                try {
                    try {
                        socketCloseCount--;
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        Object var3_2 = null;
                        this.socket = null;
                    }
                    Object var3_1 = null;
                    this.socket = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.socket = null;
                    throw throwable;
                }
            }
        }
    }
}

