/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javabean.plugins.xml;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.propertyeditor.PropertyEditors;

public class ConfigurationUtil {
    private static Configuration config;

    static synchronized void init() {
        if (config == null) {
            config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

                @Override
                public Configuration run() {
                    return new PropertyConfiguration(System.getProperties());
                }
            });
            PropertyEditors.init();
        }
    }

    static BeanInfo getBeanInfo(Object object) throws Throwable {
        return ConfigurationUtil.getBeanInfo(object.getClass());
    }

    static BeanInfo getBeanInfo(Class clazz) throws Throwable {
        return config.getBeanInfo(clazz);
    }

    static BeanInfo getBeanInfo(String className) throws Throwable {
        return config.getBeanInfo(className, Thread.currentThread().getContextClassLoader());
    }

    static PropertyInfo getPropertyInfo(Object parent, String name) throws Throwable {
        BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(parent);
        return beanInfo.getProperty(name);
    }

    static Object newInstance(String className, String[] params, Object[] args) throws Throwable {
        BeanInfo info = ConfigurationUtil.getBeanInfo(className);
        return info.newInstance(params, args);
    }

    static Object convertValue(Object parent, String name, String override, Object value) throws Throwable {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent!");
        }
        PropertyInfo property = ConfigurationUtil.getPropertyInfo(parent, name);
        return ConfigurationUtil.convertValue(property, override, value);
    }

    static Object convertValue(PropertyInfo property, String override, Object value) throws Throwable {
        if (property == null) {
            throw new IllegalArgumentException("Null property!");
        }
        TypeInfo type = property.getType();
        if (override != null) {
            type = config.getTypeInfoFactory().getTypeInfo(override, null);
        }
        return type != null ? type.convertValue(value) : value;
    }
}

