/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.client.FailoverEvent;
import org.jboss.jms.client.FailoverListener;
import org.jboss.jms.client.FailoverValve2;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.logging.Logger;

public class FailoverCommandCenter {
    private static final Logger log = Logger.getLogger(FailoverCommandCenter.class);
    private static boolean trace = log.isTraceEnabled();
    private ConnectionState state;
    private FailoverValve2 valve;
    private List failoverListeners;

    public FailoverCommandCenter(ConnectionState state) {
        this.state = state;
        this.failoverListeners = new ArrayList();
        this.valve = new FailoverValve2();
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean failureDetected(Throwable reason, FailureDetector source, JMSRemotingConnection remotingConnection) throws Exception {
        boolean bl;
        int failoverEvent;
        boolean valveOpened;
        boolean failoverSuccessful;
        block19: {
            boolean bl2;
            block18: {
                log.debug("failure detected by " + source, reason);
                this.broadcastFailoverEvent(new FailoverEvent(10, source));
                CreateConnectionResult res = null;
                failoverSuccessful = false;
                valveOpened = false;
                failoverEvent = 30;
                try {
                    try {
                        this.valve.close();
                        FailoverCommandCenter failoverCommandCenter = this;
                        synchronized (failoverCommandCenter) {
                            if (remotingConnection.isFailed()) {
                                log.debug(this + " ignoring failure detection notification, as failover was " + "already (or is in process of being) performed on this connection");
                                failoverSuccessful = true;
                                failoverEvent = 40;
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var8_8
                                Object var12_13 = null;
                                if (!valveOpened) {
                                    log.trace("finally opening valve");
                                    this.valve.open();
                                    log.trace("valve opened");
                                }
                                if (failoverSuccessful) {
                                    log.debug(this + " completed successful failover");
                                    this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
                                    return bl2;
                                }
                                log.debug(this + " aborted failover");
                                break block18;
                            }
                            remotingConnection.setFailed();
                        }
                        log.info("JBoss Messaging server failure detected - waiting for failover to complete...");
                        this.broadcastFailoverEvent(new FailoverEvent(20, this));
                        int failedNodeID = this.state.getServerID();
                        ConnectionFactoryDelegate clusteredDelegate = this.state.getClusteredConnectionFactoryDelegate();
                        log.trace("Creating new connection");
                        res = clusteredDelegate.createConnectionDelegate(this.state.getUsername(), this.state.getPassword(), failedNodeID);
                        log.trace("Created connection");
                        if (res == null) {
                            failoverSuccessful = false;
                            log.trace("No failover");
                        } else {
                            ClientConnectionDelegate newDelegate = res.getDelegate();
                            log.trace("Synchronizing state");
                            this.state.getDelegate().synchronizeWith(newDelegate);
                            log.trace("Synchronized state");
                            if (this.state.isStarted()) {
                                log.trace("Starting new connection");
                                newDelegate.startAfterFailover();
                                log.trace("Started new connection");
                            }
                            log.trace("Opening valve");
                            this.valve.open();
                            log.trace("Opened valve");
                            valveOpened = true;
                            failoverSuccessful = true;
                            log.info("JBoss Messaging failover complete");
                        }
                        log.trace("failureDetected() complete");
                        bl = failoverSuccessful;
                        break block19;
                    }
                    catch (Exception e) {
                        log.error("Failover failed", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    if (!valveOpened) {
                        log.trace("finally opening valve");
                        this.valve.open();
                        log.trace("valve opened");
                    }
                    if (failoverSuccessful) {
                        log.debug(this + " completed successful failover");
                        this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
                        throw throwable;
                    }
                    log.debug(this + " aborted failover");
                    ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
                    connDelegate.closing(-1L);
                    connDelegate.close();
                    this.broadcastFailoverEvent(new FailoverEvent(100, this));
                    throw throwable;
                }
            }
            ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
            connDelegate.closing(-1L);
            connDelegate.close();
            this.broadcastFailoverEvent(new FailoverEvent(100, this));
            return bl2;
        }
        Object var12_14 = null;
        if (!valveOpened) {
            log.trace("finally opening valve");
            this.valve.open();
            log.trace("valve opened");
        }
        if (failoverSuccessful) {
            log.debug(this + " completed successful failover");
            this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
            return bl;
        }
        log.debug(this + " aborted failover");
        ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
        connDelegate.closing(-1L);
        connDelegate.close();
        this.broadcastFailoverEvent(new FailoverEvent(100, this));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailoverListener(FailoverListener listener) {
        List list2 = this.failoverListeners;
        synchronized (list2) {
            this.failoverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterFailoverListener(FailoverListener listener) {
        List list2 = this.failoverListeners;
        synchronized (list2) {
            return this.failoverListeners.remove(listener);
        }
    }

    public FailoverValve2 getValve() {
        return this.valve;
    }

    public JMSRemotingConnection getRemotingConnection() {
        return this.state.getRemotingConnection();
    }

    public String toString() {
        return "FailoverCommandCenter[" + this.state + "]";
    }

    ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastFailoverEvent(FailoverEvent e) {
        ArrayList listenersCopy;
        if (trace) {
            log.trace(this + " broadcasting " + e);
        }
        List list2 = this.failoverListeners;
        synchronized (list2) {
            listenersCopy = new ArrayList(this.failoverListeners);
        }
        for (FailoverListener listener : listenersCopy) {
            try {
                listener.failoverEventOccured(e);
            }
            catch (Exception ex) {
                log.warn("Failover listener " + listener + " did not accept event", ex);
            }
        }
    }
}

