/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;

public class ConnectionFailureListener
implements FailureDetector {
    private static final Logger log = Logger.getLogger(ConnectionFailureListener.class);
    private FailoverCommandCenter fcc;
    private JMSRemotingConnection remotingConnection;

    ConnectionFailureListener(FailoverCommandCenter fcc, JMSRemotingConnection remotingConnection) {
        this.fcc = fcc;
        this.remotingConnection = remotingConnection;
    }

    public boolean handleConnectionException(Throwable throwable, Client client) {
        try {
            log.trace(this + " is being notified of connection failure: " + throwable);
            return this.fcc.failureDetected(throwable, this, this.remotingConnection);
        }
        catch (Throwable e) {
            log.error("Caught exception in handling failure", e);
            return false;
        }
    }

    public String toString() {
        return "ConnectionFailureListener[" + this.fcc + "]";
    }
}

