/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.ArrayList;
import java.util.List;
import javax.jms.IllegalStateException;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.destination.DestinationServiceSupport;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.jms.server.destination.QueueMBean;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.messagecounter.MessageStatistics;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.impl.MessagingQueue;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.XMLUtil;

public class QueueService
extends DestinationServiceSupport
implements QueueMBean {
    private static final String QUEUE_MESSAGECOUNTER_PREFIX = "Queue.";

    public QueueService() {
        this.destination = new ManagedQueue();
    }

    public QueueService(boolean createdProgrammatically) {
        super(createdProgrammatically);
        this.destination = new ManagedQueue();
    }

    public synchronized void startService() throws Exception {
        super.startService();
        try {
            Queue queue;
            PostOffice po = this.serverPeer.getPostOfficeInstance();
            Binding binding = po.getBindingForQueueName(this.destination.getName());
            if (binding != null) {
                queue = binding.queue;
                if (queue.isActive()) {
                    throw new IllegalStateException("Cannot deploy queue " + this.destination.getName() + " it is already deployed");
                }
                queue.setPagingParams(this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize());
                queue.load();
                queue.setMaxSize(this.destination.getMaxSize());
                queue.activate();
            } else {
                JMSCondition queueCond = new JMSCondition(true, this.destination.getName());
                queue = new MessagingQueue(this.nodeId, this.destination.getName(), this.serverPeer.getChannelIDManager().getID(), this.serverPeer.getMessageStore(), this.serverPeer.getPersistenceManagerInstance(), true, this.destination.getMaxSize(), null, this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize(), this.destination.isClustered(), this.serverPeer.getRecoverDeliveriesTimeout());
                po.addBinding(new Binding(queueCond, queue, false), false);
                queue.activate();
            }
            ((ManagedQueue)this.destination).setQueue(queue);
            String counterName = QUEUE_MESSAGECOUNTER_PREFIX + this.destination.getName();
            int dayLimitToUse = this.destination.getMessageCounterHistoryDayLimit();
            if (dayLimitToUse == -1) {
                dayLimitToUse = this.serverPeer.getDefaultMessageCounterHistoryDayLimit();
            }
            MessageCounter counter = new MessageCounter(counterName, null, queue, false, false, dayLimitToUse);
            ((ManagedQueue)this.destination).setMessageCounter(counter);
            this.serverPeer.getMessageCounterManager().registerMessageCounter(counterName, counter);
            this.serverPeer.getDestinationManager().registerDestination(this.destination);
            this.log.debug(this + " security configuration: " + (this.destination.getSecurityConfig() == null ? "null" : "\n" + XMLUtil.elementToString(this.destination.getSecurityConfig())));
            this.started = true;
            this.log.info(this + " started, fullSize=" + this.destination.getFullSize() + ", pageSize=" + this.destination.getPageSize() + ", downCacheSize=" + this.destination.getDownCacheSize());
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            this.serverPeer.getDestinationManager().unregisterDestination(this.destination);
            Queue queue = ((ManagedQueue)this.destination).getQueue();
            String counterName = QUEUE_MESSAGECOUNTER_PREFIX + this.destination.getName();
            MessageCounter counter = this.serverPeer.getMessageCounterManager().unregisterMessageCounter(counterName);
            if (counter == null) {
                throw new IllegalStateException("Cannot find counter to unregister " + counterName);
            }
            queue.deactivate();
            queue.unload();
            this.started = false;
            this.log.info(this + " stopped");
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " stopService");
        }
    }

    public int getMessageCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped");
                return 0;
            }
            return ((ManagedQueue)this.destination).getMessageCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getMessageCount");
        }
    }

    public int getDeliveringCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped");
                return 0;
            }
            return ((ManagedQueue)this.destination).getDeliveringCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getDeliveringCount");
        }
    }

    public int getScheduledMessageCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped");
                return 0;
            }
            return ((ManagedQueue)this.destination).getScheduledMessageCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getMessageCount");
        }
    }

    public MessageCounter getMessageCounter() {
        return ((ManagedQueue)this.destination).getMessageCounter();
    }

    public MessageStatistics getMessageStatistics() throws Exception {
        ArrayList<MessageCounter> counters = new ArrayList<MessageCounter>();
        counters.add(this.getMessageCounter());
        List stats = MessageCounter.getMessageStatistics(counters);
        return (MessageStatistics)stats.get(0);
    }

    public String listMessageCounterAsHTML() {
        return super.listMessageCounterAsHTML(new MessageCounter[]{this.getMessageCounter()});
    }

    public int getConsumerCount() throws Exception {
        return ((ManagedQueue)this.destination).getConsumersCount();
    }

    public void removeAllMessages() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return;
            }
            ((ManagedQueue)this.destination).removeAllMessages();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " removeAllMessages");
        }
    }

    public List listAllMessages() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listAllMessages(null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listAllMessages");
        }
    }

    public List listAllMessages(String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listAllMessages(selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listAllMessages");
        }
    }

    public List listDurableMessages() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listDurableMessages(null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
        }
    }

    public List listDurableMessages(String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listDurableMessages(selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
        }
    }

    public List listNonDurableMessages() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listNonDurableMessages(null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
        }
    }

    public List listNonDurableMessages(String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Queue is stopped.");
                return null;
            }
            return ((ManagedQueue)this.destination).listNonDurableMessages(selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
        }
    }

    public void resetMessageCounter() {
        ((ManagedQueue)this.destination).getMessageCounter().resetCounter();
    }

    public String listMessageCounterHistoryAsHTML() {
        return super.listMessageCounterHistoryAsHTML(new MessageCounter[]{this.getMessageCounter()});
    }

    public void resetMessageCounterHistory() {
        ((ManagedQueue)this.destination).getMessageCounter().resetHistory();
    }

    protected boolean isQueue() {
        return true;
    }
}

