/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.InstallKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.registry.KernelRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAction
extends KernelControllerContextAction {
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        String name = metaData.getName();
        registry.registerEntry(name, context);
        controller.addSupplies(context);
        List<InstallMetaData> installs = metaData.getInstalls();
        if (installs != null) {
            for (InstallMetaData install : installs) {
                ControllerContext target = context;
                if (install.getBean() != null) {
                    target = controller.getContext(install.getBean(), install.getDependentState());
                }
                if (target instanceof InvokeDispatchContext) {
                    InvokeDispatchHelper.invoke(configurator, target.getTarget(), target, install.getMethodName(), install.getParameters());
                    continue;
                }
                throw new IllegalArgumentException("Cannot install, context " + target + " does not implement InvokeDispatchContext");
            }
        }
    }

    @Override
    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return InstallKernelControllerContextAware.class;
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanMetaData metaData = context.getBeanMetaData();
        String name = metaData.getName();
        List<InstallMetaData> uninstalls = metaData.getUninstalls();
        if (uninstalls != null) {
            for (int i = uninstalls.size() - 1; i >= 0; --i) {
                InstallMetaData uninstall = uninstalls.get(i);
                ControllerContext target = context;
                if (uninstall.getBean() != null && (target = controller.getContext(uninstall.getBean(), uninstall.getDependentState())) == null) {
                    this.log.warn("Ignoring uninstall action on target in incorrect state " + uninstall.getBean());
                    continue;
                }
                if (target instanceof InvokeDispatchContext) {
                    try {
                        InvokeDispatchHelper.invoke(configurator, target.getTarget(), target, uninstall.getMethodName(), uninstall.getParameters());
                    }
                    catch (Throwable t) {
                        this.log.warn("Ignoring uninstall action on target " + uninstall, t);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Cannot uninstall, context " + target + " does not implement InvokeDispatchContext");
            }
        }
        try {
            controller.removeSupplies(context);
            registry.unregisterEntry(name);
        }
        catch (Throwable t) {
            this.log.warn("Ignoring unregistered entry at uninstall " + name);
        }
    }
}

