/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.Serializable;
import java.util.Collection;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMetaType<T extends Serializable>
extends AbstractMetaType {
    private static final long serialVersionUID = -2062790692152055156L;
    private MetaType elementType;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private transient String cachedToString = null;

    public CollectionMetaType(String className, MetaType<T> elementType) {
        super(className);
        if (elementType == null) {
            throw new IllegalArgumentException("Null element type");
        }
        this.elementType = elementType;
    }

    public CollectionMetaType(String className, String description, MetaType<T> elementType) {
        super(className, description);
        if (elementType == null) {
            throw new IllegalArgumentException("Null element type");
        }
        this.elementType = elementType;
    }

    public CollectionMetaType(String className, String typeName, String description, MetaType<T> elementType) {
        super(className, typeName, description);
        if (elementType == null) {
            throw new IllegalArgumentException("Null element type");
        }
        this.elementType = elementType;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public static <E extends Serializable> CollectionMetaType<E> getCollectionType(String collectionType, MetaType<E> elementType) {
        return new CollectionMetaType<E>(collectionType, elementType);
    }

    public MetaType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collection) && !(obj instanceof CollectionValue)) {
            return false;
        }
        if (obj instanceof CollectionValue) {
            CollectionValue cv = (CollectionValue)obj;
            return this.equals(cv.getMetaType());
        }
        Collection collection = (Collection)obj;
        for (Object element : collection) {
            if (this.elementType.isValue(element)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CollectionMetaType)) {
            return false;
        }
        CollectionMetaType other = (CollectionMetaType)obj;
        return this.getTypeName().equals(other.getTypeName()) && this.getElementType().equals(other.getElementType());
    }

    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode() + this.getElementType().hashCode();
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuilder buffer = new StringBuilder(CollectionMetaType.class.getSimpleName());
        buffer.append("{type=");
        buffer.append(this.getTypeName());
        buffer.append(" elementType=");
        buffer.append(this.elementType);
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

