/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.vfs;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.virtual.plugins.context.vfs.AssembledContext;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

public class AssembledContextFactory {
    private ConcurrentHashMap<String, AssembledDirectory> registry = new ConcurrentHashMap();
    private volatile int count;
    private static AssembledContextFactory instance = new AssembledContextFactory();

    public AssembledDirectory create(String name, String rootName) {
        if (this.registry.containsKey(name)) {
            throw new RuntimeException("Assembled context already exists for name: " + name);
        }
        try {
            AssembledContext context = new AssembledContext(name, rootName);
            AssembledDirectory directory = (AssembledDirectory)context.getRoot().getVirtualFile();
            this.registry.put(name, directory);
            return directory;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AssembledDirectory find(String name) {
        return this.registry.get(name);
    }

    public AssembledDirectory create(String rootName) {
        String name = "" + System.currentTimeMillis() + "" + this.count++;
        return this.create(name, rootName);
    }

    public void remove(AssembledDirectory directory) {
        try {
            if (directory.getParent() != null) {
                throw new RuntimeException("This is not the root of assembly");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.registry.remove(((AssembledContext)directory.getHandler().getVFSContext()).getName());
    }

    public static AssembledContextFactory getInstance() {
        return instance;
    }

    public static void setInstance(AssembledContextFactory instance) {
        AssembledContextFactory.instance = instance;
    }
}

