/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.BufferedStreamResult;
import org.jboss.ws.core.binding.ComplexTypeSerializer;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxws.JAXBContextCache;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.ws.extensions.xop.jaxws.AttachmentMarshallerImpl;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBSerializer
extends ComplexTypeSerializer {
    private static final Logger log = Logger.getLogger(JAXBSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        }
        BufferedStreamResult result = null;
        try {
            Class[] classArray;
            Class expectedType = serContext.getJavaType();
            Class<?> actualType = value.getClass();
            if (this.shouldFilter(actualType)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = expectedType;
            } else {
                Class[] classArray3 = new Class[2];
                classArray3[0] = expectedType;
                classArray = classArray3;
                classArray3[1] = actualType;
            }
            Class[] types = classArray;
            JAXBContext jaxbContext = this.getJAXBContext(types);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setAttachmentMarshaller((AttachmentMarshaller)new AttachmentMarshallerImpl());
            result = new BufferedStreamResult();
            marshaller.marshal((Object)new JAXBElement(xmlName, expectedType, value), (Result)result);
            if (log.isDebugEnabled()) {
                log.debug("serialized: " + result);
            }
        }
        catch (Exception ex) {
            this.handleMarshallException(ex);
        }
        return result;
    }

    private JAXBContext getJAXBContext(Class[] types) {
        JAXBContextCache cache = JAXBContextCache.getContextCache();
        JAXBContext context = cache.get(types);
        if (null == context) {
            BindingCustomization bindingCustomization = this.getBindingCustomization();
            context = JAXBContextFactory.newInstance().createContext(types, bindingCustomization);
            cache.add(types, context);
        }
        return context;
    }

    private boolean shouldFilter(Class<?> actualType) {
        return XMLGregorianCalendar.class.isAssignableFrom(actualType);
    }

    private void handleMarshallException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException(ex);
    }
}

