/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.jaxws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.Action;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.ReferenceParameters;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.annotation.EndpointConfig;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.eventing.common.EventingEndpointBase;
import org.jboss.ws.extensions.eventing.jaxws.GetStatus;
import org.jboss.ws.extensions.eventing.jaxws.GetStatusResponse;
import org.jboss.ws.extensions.eventing.jaxws.Renew;
import org.jboss.ws.extensions.eventing.jaxws.RenewResponse;
import org.jboss.ws.extensions.eventing.jaxws.SubscriptionManagerEndpoint;
import org.jboss.ws.extensions.eventing.jaxws.Unsubscribe;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionError;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(name="SubscriptionManager", portName="SubscriptionManagerPort", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", wsdlLocation="/WEB-INF/wsdl/wind.wsdl")
@EndpointConfig(configName="Standard WSAddressing Endpoint")
public abstract class AbstractSubscriptionManagerEndpoint
extends EventingEndpointBase
implements SubscriptionManagerEndpoint {
    public static final QName IDQN = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "ns1");

    @WebMethod(operationName="GetStatusOp")
    @WebResult(name="GetStatusResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
    @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse")
    public GetStatusResponse getStatusOp(@WebParam(name="GetStatus", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") GetStatus body) {
        URI identifier = this.retrieveSubscriptionId();
        this.getLogger().debug("GetStatus request for subscriptionID: " + identifier);
        try {
            Date leaseTime = this.getSubscriptionManager().getStatus(identifier);
            GetStatusResponse response = new GetStatusResponse();
            response.setExpires(leaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    @WebMethod(operationName="RenewOp")
    @WebResult(name="RenewResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
    @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse")
    public RenewResponse renewOp(@WebParam(name="Renew", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Renew request) {
        URI identifier = this.retrieveSubscriptionId();
        this.getLogger().debug("Renew request for subscriptionID: " + identifier);
        try {
            Date newLeaseTime = this.getSubscriptionManager().renew(identifier, request.getExpires());
            RenewResponse response = new RenewResponse();
            response.setExpires(newLeaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    @WebMethod(operationName="UnsubscribeOp")
    @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse")
    public void unsubscribeOp(@WebParam(name="Unsubscribe", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Unsubscribe body) {
        URI identifier = this.retrieveSubscriptionId();
        this.getLogger().debug("Unsubscribe request for subscriptionID: " + identifier);
        try {
            this.getSubscriptionManager().unsubscribe(identifier);
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    private URI retrieveSubscriptionId() {
        URI subscriptionId = null;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties addrProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
        if (null == addrProps) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed: Cannot obtain addressing properties.", null, null);
        }
        ReferenceParameters refParams = addrProps.getReferenceParameters();
        if (refParams != null) {
            for (Object obj : refParams.getElements()) {
                Element el;
                QName qname;
                if (!(obj instanceof Element) || !(qname = DOMUtils.getElementQName((Element)(el = (Element)obj))).equals(IDQN)) continue;
                try {
                    subscriptionId = new URI(DOMUtils.getTextContent((Node)el));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed: Invalid subscription id.", null, null);
                }
            }
        }
        if (null == subscriptionId) {
            throw new SOAPFaultException(this.buildFaultQName("InvalidMessage"), "The message is not valid and cannot be processed: Cannot obtain subscription id.", null, null);
        }
        return subscriptionId;
    }

    protected abstract Logger getLogger();
}

