/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxrpc;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCMetaDataBuilder;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public class JAXRPCClientMetaDataBuilder
extends JAXRPCMetaDataBuilder {
    private final Logger log = Logger.getLogger(JAXRPCClientMetaDataBuilder.class);

    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, URL mappingURL, URL securityURL, UnifiedServiceRefMetaData serviceRefMetaData, ClassLoader loader) {
        try {
            JavaWsdlMapping javaWsdlMapping = null;
            if (mappingURL != null) {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                javaWsdlMapping = mappingFactory.parse(mappingURL);
            }
            WSSecurityConfiguration securityConfig = null;
            if (securityURL != null) {
                securityConfig = WSSecurityOMFactory.newInstance().parse(securityURL);
            }
            return this.buildMetaData(serviceQName, wsdlURL, javaWsdlMapping, securityConfig, serviceRefMetaData, loader);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    public ServiceMetaData buildMetaData(QName serviceQName, URL wsdlURL, JavaWsdlMapping javaWsdlMapping, WSSecurityConfiguration securityConfig, UnifiedServiceRefMetaData usrMetaData, ClassLoader loader) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("START buildMetaData: [service=" + serviceQName + "]");
        }
        try {
            ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter(loader);
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
            wsMetaData.setClassLoader(loader);
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, serviceQName);
            wsMetaData.addService(serviceMetaData);
            serviceMetaData.setWsdlLocation(wsdlURL);
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            if (javaWsdlMapping != null) {
                URL mappingURL = new URL("http://www.jboss.org/jbossws/dummy-mapping-file");
                if (usrMetaData != null && usrMetaData.getMappingLocation() != null) {
                    mappingURL = usrMetaData.getMappingLocation();
                }
                wsMetaData.addMappingDefinition(mappingURL.toExternalForm(), javaWsdlMapping);
                serviceMetaData.setMappingLocation(mappingURL);
            }
            if (securityConfig != null) {
                serviceMetaData.setSecurityConfiguration(securityConfig);
                this.setupSecurity(securityConfig, wsMetaData.getRootFile());
            }
            this.buildMetaDataInternal(serviceMetaData, wsdlDefinitions, javaWsdlMapping, usrMetaData);
            wsMetaData.eagerInitialize();
            if (this.log.isDebugEnabled()) {
                this.log.debug("END buildMetaData: " + wsMetaData);
            }
            return serviceMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private void buildMetaDataInternal(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, JavaWsdlMapping javaWsdlMapping, UnifiedServiceRefMetaData serviceRefMetaData) throws IOException {
        QName serviceQName = serviceMetaData.getServiceName();
        WSDLService wsdlService = null;
        if (serviceQName == null) {
            if (wsdlDefinitions.getServices().length != 1) {
                throw new IllegalArgumentException("Expected a single service element");
            }
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setServiceName(wsdlService.getName());
        } else {
            wsdlService = wsdlDefinitions.getService(serviceQName);
        }
        if (wsdlService == null) {
            throw new IllegalArgumentException("Cannot obtain wsdl service: " + serviceQName);
        }
        this.setupTypesMetaData(serviceMetaData);
        for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
            QName bindingName = wsdlEndpoint.getBinding();
            WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
            String bindingType = wsdlBinding.getType();
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) continue;
            QName portName = wsdlEndpoint.getName();
            QName interfaceQName = wsdlEndpoint.getInterface().getName();
            ClientEndpointMetaData epMetaData = new ClientEndpointMetaData(serviceMetaData, portName, interfaceQName, EndpointMetaData.Type.JAXRPC);
            epMetaData.setEndpointAddress(wsdlEndpoint.getAddress());
            serviceMetaData.addEndpoint(epMetaData);
            if (serviceRefMetaData != null) {
                String configName = serviceRefMetaData.getConfigName();
                String configFile = serviceRefMetaData.getConfigFile();
                if (configName != null || configFile != null) {
                    epMetaData.setConfigName(configName, configFile);
                }
            }
            this.initEndpointBinding(wsdlEndpoint, epMetaData);
            this.initEndpointEncodingStyle(epMetaData);
            ServiceEndpointInterfaceMapping seiMapping = null;
            if (javaWsdlMapping != null) {
                QName portType = wsdlEndpoint.getInterface().getName();
                seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMappingByPortType(portType);
                if (seiMapping != null) {
                    epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                } else {
                    this.log.warn("Cannot obtain the SEI mapping for: " + portType);
                }
            }
            this.processEndpointMetaDataExtensions(epMetaData, wsdlDefinitions);
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
            this.setupHandlers(serviceRefMetaData, portName, epMetaData);
        }
    }

    private void setupHandlers(UnifiedServiceRefMetaData serviceRefMetaData, QName portName, EndpointMetaData epMetaData) {
        if (serviceRefMetaData != null) {
            for (UnifiedHandlerMetaData uhmd : serviceRefMetaData.getHandlers()) {
                Set<String> portNames = uhmd.getPortNames();
                if (portNames.size() != 0 && !portNames.contains(portName.getLocalPart())) continue;
                HandlerMetaDataJAXRPC hmd = HandlerMetaDataJAXRPC.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                epMetaData.addHandler(hmd);
            }
        }
    }

    private void setupSecurity(WSSecurityConfiguration securityConfig, UnifiedVirtualFile vfsRoot) {
        UnifiedVirtualFile child;
        if (securityConfig.getKeyStoreFile() != null) {
            try {
                child = vfsRoot.findChild(securityConfig.getKeyStoreFile());
                securityConfig.setKeyStoreURL(child.toURL());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (securityConfig.getTrustStoreFile() != null) {
            try {
                child = vfsRoot.findChild(securityConfig.getTrustStoreFile());
                securityConfig.setTrustStoreURL(child.toURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

