/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jboss.logging.Logger;
import org.jboss.ws.core.utils.ResourceURL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXSEntityResolver
implements XMLEntityResolver {
    private static final Logger log = Logger.getLogger(JBossXSEntityResolver.class);
    private Map<String, URL> schemaLocationByNamespace = new HashMap<String, URL>();
    private EntityResolver delegate;

    public JBossXSEntityResolver(EntityResolver resolver, Map<String, URL> schemaLocationByNamespace) {
        this.schemaLocationByNamespace = schemaLocationByNamespace;
        this.delegate = resolver;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resId) throws XNIException, IOException {
        String namespaceURI;
        log.trace("Resolve entity: " + resId);
        String publicId = resId.getPublicId();
        String systemId = resId.getLiteralSystemId();
        String namespace = resId.getNamespace();
        try {
            String publicURI = publicId != null ? publicId : namespace;
            InputSource inputSource = this.delegate.resolveEntity(publicURI, systemId);
            if (inputSource != null) {
                XMLInputSource source = this.getXMLInputSource(inputSource, resId);
                return source;
            }
        }
        catch (Exception ex) {
            log.trace(ex);
        }
        try {
            String expandedSysId = resId.getExpandedSystemId();
            if (expandedSysId != null) {
                log.trace("Use ExpandedSystemId: " + expandedSysId);
                return this.getXMLInputSource(new URL(expandedSysId), resId);
            }
        }
        catch (IOException e) {
            log.trace(e);
        }
        try {
            if (systemId != null) {
                log.trace("Use LiteralSystemId: " + systemId);
                return this.getXMLInputSource(new URL(systemId), resId);
            }
        }
        catch (IOException e) {
            log.trace(e);
        }
        String string = namespaceURI = resId.getNamespace() != null ? resId.getNamespace() : resId.getLiteralSystemId();
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
            return null;
        }
        try {
            URL url = this.schemaLocationByNamespace.get(namespaceURI);
            if (url != null) {
                log.trace("Use SchemaLocationByNamespace: " + url);
                return this.getXMLInputSource(url, resId);
            }
            XMLInputSource source = this.getXMLInputSource(this.delegate.resolveEntity(null, namespaceURI), resId);
            if (source != null) {
                return source;
            }
        }
        catch (SAXException e) {
            log.trace(e);
        }
        try {
            log.trace("Use NamespaceURI: " + namespaceURI);
            return this.getXMLInputSource(new URL(namespaceURI), resId);
        }
        catch (IOException e) {
            log.trace(e);
            log.trace("Cannot obtain XMLInputSource for: " + resId);
            return null;
        }
    }

    private XMLInputSource getXMLInputSource(URL url, XMLResourceIdentifier resId) throws IOException {
        InputStream inputStream = new ResourceURL(url).openStream();
        InputSource inputSource = new InputSource(inputStream);
        return this.getXMLInputSource(inputSource, resId);
    }

    private XMLInputSource getXMLInputSource(InputSource inputSource, XMLResourceIdentifier resId) {
        String encoding = inputSource.getEncoding();
        InputStream byteStream = inputSource.getByteStream();
        return new XMLInputSource(resId.getPublicId(), resId.getExpandedSystemId(), resId.getBaseSystemId(), byteStream, encoding);
    }
}

