/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.junit;

import java.net.URL;
import javax.management.MBeanServerConnection;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.adapters.JMXKernel;
import org.jboss.test.JBossTestServices;

public class ClasspathBasedTestServices
extends JBossTestServices {
    private boolean top;
    private Bootstrap bootstrap;

    public ClasspathBasedTestServices(String className) {
        super(className);
    }

    public ClasspathBasedTestServices(Class clazz) {
        super(clazz);
    }

    public void setUp() throws Exception {
        this.bootstrap = Bootstrap.getInstance();
        if (!this.bootstrap.isStarted()) {
            this.bootstrap.bootstrap();
            this.top = true;
        }
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.top) {
            this.bootstrap.shutdown();
        }
    }

    public MBeanServerConnection getServer() throws Exception {
        if (this.server == null) {
            JMXKernel jmxKernel = (JMXKernel)this.bootstrap.getKernel().getRegistry().getEntry((Object)"JMXKernel").getTarget();
            this.server = jmxKernel.getMbeanServer();
        }
        return this.server;
    }

    public void deploy(String name) throws Exception {
        URL url = this.getDeployURL(name);
        this.bootstrap.deploy(url);
    }

    public void redeploy(String name) throws Exception {
        URL url = this.getDeployURL(name);
        this.bootstrap.deploy(url);
    }

    public void undeploy(String name) throws Exception {
        URL url = this.getDeployURL(name);
        this.bootstrap.undeploy(url);
    }
}

