/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Date;
import org.quartz.SchedulerException;

public class SchedulerMetaData
implements Serializable {
    private String schedName;
    private String schedInst;
    private Class schedClass;
    private boolean isRemote;
    private boolean started;
    private boolean paused;
    private boolean shutdown;
    private Date startTime;
    private int numJobsExec;
    private Class jsClass;
    private boolean jsPersistent;
    private Class tpClass;
    private int tpSize;
    private String version;

    public SchedulerMetaData(String schedName, String schedInst, Class schedClass, boolean isRemote, boolean started, boolean paused, boolean shutdown, Date startTime, int numJobsExec, Class jsClass, boolean jsPersistent, Class tpClass, int tpSize, String version) {
        this.schedName = schedName;
        this.schedInst = schedInst;
        this.schedClass = schedClass;
        this.isRemote = isRemote;
        this.started = started;
        this.paused = paused;
        this.shutdown = shutdown;
        this.startTime = startTime;
        this.numJobsExec = numJobsExec;
        this.jsClass = jsClass;
        this.jsPersistent = jsPersistent;
        this.tpClass = tpClass;
        this.tpSize = tpSize;
        this.version = version;
    }

    public String getSchedulerName() {
        return this.schedName;
    }

    public String getSchedulerInstanceId() {
        return this.schedInst;
    }

    public Class getSchedulerClass() {
        return this.schedClass;
    }

    public Date runningSince() {
        return this.startTime;
    }

    public int numJobsExecuted() {
        return this.numJobsExec;
    }

    public boolean isSchedulerRemote() {
        return this.isRemote;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public Class getJobStoreClass() {
        return this.jsClass;
    }

    public boolean jobStoreSupportsPersistence() {
        return this.jsPersistent;
    }

    public Class getThreadPoolClass() {
        return this.tpClass;
    }

    public int getThreadPoolSize() {
        return this.tpSize;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        try {
            return this.getSummary();
        }
        catch (SchedulerException se) {
            return "SchedulerMetaData: undeterminable.";
        }
    }

    public String getSummary() throws SchedulerException {
        StringBuffer str = new StringBuffer("Quartz Scheduler (v");
        str.append(this.getVersion());
        str.append(") '");
        str.append(this.getSchedulerName());
        str.append("' with instanceId '");
        str.append(this.getSchedulerInstanceId());
        str.append("'\n");
        str.append("  Scheduler class: '");
        str.append(this.getSchedulerClass().getName());
        str.append("'");
        if (this.isSchedulerRemote()) {
            str.append(" - access via RMI.");
        } else {
            str.append(" - running locally.");
        }
        str.append("\n");
        if (!this.isShutdown()) {
            if (this.runningSince() != null) {
                str.append("  Running since: ");
                str.append(this.runningSince());
            } else {
                str.append("NOT STARTED.");
            }
            str.append("\n");
            if (this.isPaused()) {
                str.append("  Currently PAUSED.");
            } else {
                str.append("  Not currently paused.");
            }
        } else {
            str.append("  Scheduler has been SHUTDOWN.");
        }
        str.append("\n");
        str.append("  Number of jobs executed: ");
        str.append(this.numJobsExecuted());
        str.append("\n");
        str.append("  Using thread pool '");
        str.append(this.getThreadPoolClass().getName());
        str.append("' - with ");
        str.append(this.getThreadPoolSize());
        str.append(" threads.");
        str.append("\n");
        str.append("  Using job-store '");
        str.append(this.getJobStoreClass().getName());
        str.append("' - which ");
        if (this.jobStoreSupportsPersistence()) {
            str.append("supports persistence.");
        } else {
            str.append("does not support persistence.");
        }
        str.append("\n");
        return str.toString();
    }
}

