/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SyncCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SyncList
extends SyncCollection
implements List {
    public SyncList(List list, Sync sync) {
        super((Collection)list, sync);
    }

    public SyncList(List list, ReadWriteLock rwl) {
        super(list, rwl.readLock(), rwl.writeLock());
    }

    public SyncList(List list, Sync readLock, Sync writeLock) {
        super(list, readLock, writeLock);
    }

    protected List baseList() {
        return (List)this.c_;
    }

    public int hashCode() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.c_.hashCode();
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public boolean equals(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.equals(o);
            return bl;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public Object get(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object e = this.baseList().get(index);
            return e;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public int indexOf(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.baseList().indexOf(o);
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public int lastIndexOf(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.baseList().lastIndexOf(o);
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public List subList(int fromIndex, int toIndex) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncList syncList = new SyncList(this.baseList().subList(fromIndex, toIndex), this.rd_, this.wr_);
            return syncList;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public Object set(int index, Object o) {
        this.wr_.acquire();
        try {
            Object object = this.baseList().set(index, o);
            this.wr_.release();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public Object remove(int index) {
        this.wr_.acquire();
        try {
            Object e = this.baseList().remove(index);
            this.wr_.release();
            return e;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public void add(int index, Object o) {
        try {
            this.wr_.acquire();
            try {
                this.baseList().add(index, o);
            }
            finally {
                this.wr_.release();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public boolean addAll(int index, Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.baseList().addAll(index, coll);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public ListIterator unprotectedListIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            ListIterator listIterator = this.baseList().listIterator();
            return listIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public ListIterator listIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionListIterator syncCollectionListIterator = new SyncCollectionListIterator((Iterator)this.baseList().listIterator());
            return syncCollectionListIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public ListIterator unprotectedListIterator(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            ListIterator listIterator = this.baseList().listIterator(index);
            return listIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public ListIterator listIterator(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionListIterator syncCollectionListIterator = new SyncCollectionListIterator((Iterator)this.baseList().listIterator(index));
            return syncCollectionListIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public class SyncCollectionListIterator
    extends SyncCollection.SyncCollectionIterator
    implements ListIterator {
        SyncCollectionListIterator(Iterator baseIterator) {
            super(baseIterator);
        }

        protected ListIterator baseListIterator() {
            return (ListIterator)this.baseIterator_;
        }

        public boolean hasPrevious() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                boolean bl = this.baseListIterator().hasPrevious();
                return bl;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        public Object previous() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                Object e = this.baseListIterator().previous();
                return e;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        public int nextIndex() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                int n = this.baseListIterator().nextIndex();
                return n;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        public int previousIndex() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                int n = this.baseListIterator().previousIndex();
                return n;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        public void set(Object o) {
            try {
                SyncList.this.wr_.acquire();
                try {
                    this.baseListIterator().set(o);
                }
                finally {
                    SyncList.this.wr_.release();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }

        public void add(Object o) {
            try {
                SyncList.this.wr_.acquire();
                try {
                    this.baseListIterator().add(o);
                }
                finally {
                    SyncList.this.wr_.release();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }
}

