/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class CronTrigger
extends Trigger {
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    private CronExpression cronEx = null;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private transient TimeZone timeZone = null;

    public CronTrigger() {
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    public CronTrigger(String name, String group) {
        super(name, group);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    public CronTrigger(String name, String group, String cronExpression) throws ParseException {
        super(name, group);
        this.setCronExpression(cronExpression);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    public CronTrigger(String name, String group, String jobName, String jobGroup) {
        super(name, group, jobName, jobGroup);
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    public CronTrigger(String name, String group, String jobName, String jobGroup, String cronExpression) throws ParseException {
        this(name, group, jobName, jobGroup, null, null, cronExpression, TimeZone.getDefault());
    }

    public CronTrigger(String name, String group, String jobName, String jobGroup, String cronExpression, TimeZone timeZone) throws ParseException {
        this(name, group, jobName, jobGroup, null, null, cronExpression, timeZone);
    }

    public CronTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, String cronExpression) throws ParseException {
        super(name, group, jobName, jobGroup);
        this.setCronExpression(cronExpression);
        if (startTime == null) {
            startTime = new Date();
        }
        this.setStartTime(startTime);
        if (endTime != null) {
            this.setEndTime(endTime);
        }
        this.setTimeZone(TimeZone.getDefault());
    }

    public CronTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, String cronExpression, TimeZone timeZone) throws ParseException {
        super(name, group, jobName, jobGroup);
        this.setCronExpression(cronExpression);
        if (startTime == null) {
            startTime = new Date();
        }
        this.setStartTime(startTime);
        if (endTime != null) {
            this.setEndTime(endTime);
        }
        if (timeZone == null) {
            this.setTimeZone(TimeZone.getDefault());
        } else {
            this.setTimeZone(timeZone);
        }
    }

    public Object clone() {
        CronTrigger copy = (CronTrigger)super.clone();
        copy.setCronExpression((CronExpression)this.cronEx.clone());
        return copy;
    }

    public void setCronExpression(String cronExpression) throws ParseException {
        this.cronEx = new CronExpression(cronExpression);
        this.cronEx.setTimeZone(this.getTimeZone());
    }

    public String getCronExpression() {
        return this.cronEx == null ? null : this.cronEx.getCronExpression();
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronEx = cronExpression;
        this.timeZone = cronExpression.getTimeZone();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.startTime = cl.getTime();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public TimeZone getTimeZone() {
        if (this.cronEx != null) {
            return this.cronEx.getTimeZone();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.cronEx != null) {
            this.cronEx.setTimeZone(timeZone);
        }
        this.timeZone = timeZone;
    }

    public Date getFireTimeAfter(Date afterTime) {
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.startTime.after(afterTime)) {
            afterTime = new Date(this.startTime.getTime() - 1000L);
        }
        Date pot = this.getTimeAfter(afterTime);
        if (this.endTime != null && pot != null && pot.after(this.endTime)) {
            return null;
        }
        return pot;
    }

    public Date getFinalFireTime() {
        if (this.endTime != null) {
            return this.getTimeBefore(this.endTime);
        }
        return null;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 1;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public boolean willFireOn(java.util.Calendar test) {
        return this.willFireOn(test, false);
    }

    public boolean willFireOn(java.util.Calendar test, boolean dayOnly) {
        test = (java.util.Calendar)test.clone();
        test.set(14, 0);
        if (dayOnly) {
            test.set(10, 0);
            test.set(12, 0);
            test.set(13, 0);
        }
        Date testTime = test.getTime();
        Date fta = this.getFireTimeAfter(new Date(test.getTime().getTime() - 1000L));
        java.util.Calendar p = java.util.Calendar.getInstance(test.getTimeZone());
        p.setTime(fta);
        int year = p.get(1);
        int month = p.get(2);
        int day = p.get(5);
        if (dayOnly) {
            return year == test.get(1) && month == test.get(2) && day == test.get(5);
        }
        while (fta.before(testTime)) {
            fta = this.getFireTimeAfter(fta);
        }
        return fta.equals(testTime);
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public void triggered(Calendar calendar) {
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        block1: {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
            Date now = new Date();
            while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
                this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) break block1;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
        return this.nextFireTime;
    }

    public String getExpressionSummary() {
        return this.cronEx == null ? null : this.cronEx.getExpressionSummary();
    }

    protected Date getTimeAfter(Date afterTime) {
        return this.cronEx.getTimeAfter(afterTime);
    }

    protected Date getTimeBefore(Date endTime) {
        return null;
    }

    public static void main(String[] args) throws Exception {
        String expr = "15 10 0/4 * * ?";
        if (args != null && args.length > 0 && args[0] != null) {
            expr = args[0];
        }
        CronTrigger ct = new CronTrigger("t", "g", "j", "g", new Date(), null, expr);
        ct.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        System.err.println(ct.getExpressionSummary());
        System.err.println("tz=" + ct.getTimeZone().getID());
        System.err.println();
        List times = TriggerUtils.computeFireTimes(ct, null, 25);
        for (int i = 0; i < times.size(); ++i) {
            System.err.println("firetime = " + times.get(i));
        }
        java.util.Calendar tt = java.util.Calendar.getInstance();
        tt.set(5, 17);
        tt.set(2, 4);
        tt.set(10, 11);
        tt.set(12, 0);
        tt.set(13, 7);
        System.err.println("\nWill fire on: " + tt.getTime() + " -- " + ct.willFireOn(tt, false));
    }
}

