/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateful;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.logging.Logger;
import org.jboss.seam.examples.booking.inventory.SearchCriteria;
import org.jboss.seam.examples.booking.model.Hotel;
import org.jboss.seam.examples.booking.model.Hotel_;
import org.jboss.seam.international.status.builder.TemplateMessage;

@Named
@Stateful
@SessionScoped
public class HotelSearch {
    @Inject
    private Logger log;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private SearchCriteria criteria;
    @Inject
    private Instance<TemplateMessage> messageBuilder;
    private boolean nextPageAvailable = false;
    private List<Hotel> hotels = new ArrayList();

    public void find() {
        this.criteria.firstPage();
        this.queryHotels(this.criteria);
    }

    public void nextPage() {
        this.criteria.nextPage();
        this.queryHotels(this.criteria);
    }

    public void previousPage() {
        this.criteria.previousPage();
        this.queryHotels(this.criteria);
    }

    @Produces
    @Named
    public List<Hotel> getHotels() {
        return this.hotels;
    }

    public boolean isNextPageAvailable() {
        return this.nextPageAvailable;
    }

    public boolean isPreviousPageAvailable() {
        return this.criteria.getPage() > 0;
    }

    private void queryHotels(SearchCriteria criteria) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cquery = builder.createQuery(Hotel.class);
        Root hotel = cquery.from(Hotel.class);
        cquery.select((Selection)hotel).where((Expression)builder.or(new Predicate[]{builder.like(builder.lower((Expression)hotel.get(Hotel_.name)), criteria.getSearchPattern()), builder.like(builder.lower((Expression)hotel.get(Hotel_.city)), criteria.getSearchPattern()), builder.like(builder.lower((Expression)hotel.get(Hotel_.zip)), criteria.getSearchPattern()), builder.like(builder.lower((Expression)hotel.get(Hotel_.address)), criteria.getSearchPattern())}));
        List results = this.em.createQuery(cquery).setMaxResults(criteria.getFetchSize()).setFirstResult(criteria.getFetchOffset()).getResultList();
        this.nextPageAvailable = results.size() > criteria.getPageSize();
        this.hotels = this.nextPageAvailable ? new ArrayList(results.subList(0, criteria.getPageSize())) : results;
        this.log.info((Object)((TemplateMessage)this.messageBuilder.get()).text("Found {0} hotel(s) matching search term [ {1} ] (limit {2})").textParams(new Object[]{this.hotels.size(), criteria.getQuery(), criteria.getPageSize()}).build().getText());
    }
}

