/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.jboss.seam.examples.booking.model.CreditCardType;
import org.jboss.seam.examples.booking.model.Hotel;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.solder.core.Veto;

@Entity
@Veto
public class Booking
implements Serializable {
    private Long id;
    private User user;
    private Hotel hotel;
    private Date checkinDate;
    private Date checkoutDate;
    private String creditCardNumber;
    private CreditCardType creditCardType;
    private String creditCardName;
    private int creditCardExpiryMonth;
    private int creditCardExpiryYear;
    private boolean smoking;
    private int beds;

    public Booking() {
    }

    public Booking(Hotel hotel, User user, int daysFromNow, int nights) {
        this.hotel = hotel;
        this.user = user;
        this.creditCardName = user.getName();
        this.smoking = false;
        this.beds = 1;
        this.setReservationDates(daysFromNow, nights);
        this.creditCardExpiryMonth = Calendar.getInstance().get(2) + 1;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Temporal(value=TemporalType.DATE)
    public Date getCheckinDate() {
        return this.checkinDate;
    }

    public void setCheckinDate(Date datetime) {
        this.checkinDate = datetime;
    }

    @NotNull
    @ManyToOne
    public Hotel getHotel() {
        return this.hotel;
    }

    public void setHotel(Hotel hotel) {
        this.hotel = hotel;
    }

    @NotNull
    @ManyToOne
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Temporal(value=TemporalType.DATE)
    public Date getCheckoutDate() {
        return this.checkoutDate;
    }

    public void setCheckoutDate(Date checkoutDate) {
        this.checkoutDate = checkoutDate;
    }

    public boolean isSmoking() {
        return this.smoking;
    }

    public void setSmoking(boolean smoking) {
        this.smoking = smoking;
    }

    public int getBeds() {
        return this.beds;
    }

    public void setBeds(int beds) {
        this.beds = beds;
    }

    @NotNull(message="Credit card number is required")
    @Size(min=16, max=16, message="Credit card number must 16 digits long")
    @Digits(fraction=0, integer=16)
    @CreditCardNumber
    public String getCreditCardNumber() {
        return this.creditCardNumber;
    }

    public void setCreditCardNumber(String creditCardNumber) {
        this.creditCardNumber = creditCardNumber;
    }

    @NotNull(message="Credit card type is required")
    @Enumerated(value=EnumType.STRING)
    public CreditCardType getCreditCardType() {
        return this.creditCardType;
    }

    public void setCreditCardType(CreditCardType creditCardType) {
        this.creditCardType = creditCardType;
    }

    @NotNull(message="Credit card name is required")
    @Size(min=3, max=70, message="Credit card name is required")
    public String getCreditCardName() {
        return this.creditCardName;
    }

    public void setCreditCardName(String creditCardName) {
        this.creditCardName = creditCardName;
    }

    public int getCreditCardExpiryMonth() {
        return this.creditCardExpiryMonth;
    }

    public void setCreditCardExpiryMonth(int creditCardExpiryMonth) {
        this.creditCardExpiryMonth = creditCardExpiryMonth;
    }

    public int getCreditCardExpiryYear() {
        return this.creditCardExpiryYear;
    }

    public void setCreditCardExpiryYear(int creditCardExpiryYear) {
        this.creditCardExpiryYear = creditCardExpiryYear;
    }

    @Transient
    public String getDescription() {
        DateFormat df = DateFormat.getDateInstance(2);
        return this.hotel == null ? null : this.hotel.getName() + ", " + df.format(this.getCheckinDate()) + " to " + df.format(this.getCheckoutDate());
    }

    @Transient
    public BigDecimal getTotal() {
        return this.hotel.getPrice().multiply(new BigDecimal(this.getNights()));
    }

    @Transient
    public int getNights() {
        return (int)(this.checkoutDate.getTime() - this.checkinDate.getTime()) / 1000 / 60 / 60 / 24;
    }

    public void setReservationDates(int daysFromNow, int nights) {
        Calendar refDate = Calendar.getInstance();
        refDate.set(refDate.get(1), refDate.get(2), refDate.get(5) + daysFromNow, 0, 0, 0);
        this.setCheckinDate(refDate.getTime());
        refDate.add(5, nights);
        this.setCheckoutDate(refDate.getTime());
    }

    public String toString() {
        return "Booking(" + this.user + ", " + this.hotel + ")";
    }
}

