/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.security;

import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.logging.Logger;
import org.jboss.seam.examples.booking.account.Authenticated;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.examples.booking.security.Credentials;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;

@Stateless
public class Authenticator {
    @Inject
    private Logger log;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Credentials credentials;
    @Inject
    private Messages messages;
    @Inject
    @Authenticated
    private Event<User> loginEventSrc;

    public boolean authenticate() {
        this.log.info((Object)("Logging in " + this.credentials.getUsername()));
        if (this.credentials.getUsername() == null || this.credentials.getPassword() == null) {
            this.messages.error((BundleKey)new DefaultBundleKey("identity_loginFailed")).defaults("Invalid username or password");
            return false;
        }
        User user = (User)this.em.find(User.class, (Object)this.credentials.getUsername());
        if (user != null && user.getPassword().equals(this.credentials.getPassword())) {
            this.loginEventSrc.fire((Object)user);
            this.messages.info((BundleKey)new DefaultBundleKey("identity_loggedIn"), new Object[]{user.getName()}).defaults("You're signed in as {0}").params(new Object[]{user.getName()});
            return true;
        }
        this.messages.error((BundleKey)new DefaultBundleKey("identity_loginFailed")).defaults("Invalid username or password");
        return false;
    }
}

