/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.account;

import javax.ejb.Stateful;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;

@Stateful
@Model
public class Registrar {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Messages messages;
    @Inject
    private FacesContext facesContext;
    private UIInput usernameInput;
    private final User newUser = new User();
    @NotNull
    @Size(min=5, max=15)
    private String confirmPassword;
    private boolean registered;
    private boolean registrationInvalid;

    public void register() {
        if (this.verifyUsernameIsAvailable()) {
            this.registered = true;
            this.em.persist((Object)this.newUser);
            this.messages.info((BundleKey)new DefaultBundleKey("registration_registered")).defaults("You have been successfully registered as the user {0}! You can now login.").params(new Object[]{this.newUser.getUsername()});
        } else {
            this.registrationInvalid = true;
        }
    }

    public boolean isRegistrationInvalid() {
        return this.registrationInvalid;
    }

    public void notifyIfRegistrationIsInvalid() {
        if (this.facesContext.isValidationFailed() || this.registrationInvalid) {
            this.messages.warn((BundleKey)new DefaultBundleKey("registration_invalid")).defaults("Invalid registration. Please correct the errors and try again.");
        }
    }

    @Produces
    @Named
    public User getNewUser() {
        return this.newUser;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String password) {
        this.confirmPassword = password;
    }

    public UIInput getUsernameInput() {
        return this.usernameInput;
    }

    public void setUsernameInput(UIInput usernameInput) {
        this.usernameInput = usernameInput;
    }

    private boolean verifyUsernameIsAvailable() {
        User existing = (User)this.em.find(User.class, (Object)this.newUser.getUsername());
        if (existing != null) {
            this.messages.warn(new BundleKey("messages", "account_usernameTaken")).defaults("The username '{0}' is already taken. Please choose another username.").targets(this.usernameInput.getClientId()).params(new Object[]{this.newUser.getUsername()});
            return false;
        }
        return true;
    }
}

