/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.booking;

import java.text.DateFormat;
import java.util.List;
import javax.ejb.Stateful;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.logging.Logger;
import org.jboss.seam.examples.booking.account.Authenticated;
import org.jboss.seam.examples.booking.booking.Confirmed;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.model.Booking;
import org.jboss.seam.examples.booking.model.Booking_;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.examples.booking.model.User_;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.security.Identity;

@Stateful
@SessionScoped
@Named
public class BookingHistory {
    @Inject
    private Logger log;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private Messages messages;
    @Inject
    private Identity identity;
    @Inject
    @Authenticated
    private Instance<User> currentUserInstance;
    private List<Booking> bookingsForUser = null;

    @Produces
    @Authenticated
    @Named(value="bookings")
    public List<Booking> getBookingsForCurrentUser() {
        if (this.bookingsForUser == null && this.identity.isLoggedIn()) {
            this.fetchBookingsForCurrentUser();
        }
        return this.bookingsForUser;
    }

    public void onBookingComplete(@Observes(during=TransactionPhase.AFTER_SUCCESS, notifyObserver=Reception.IF_EXISTS) @Confirmed Booking booking) {
        if (this.bookingsForUser != null) {
            this.log.info((Object)"Adding new booking to user's cached booking history");
            this.bookingsForUser.add(booking);
        } else {
            this.log.info((Object)"User's booking history not loaded. Skipping cache update.");
        }
    }

    public void cancelBooking(Booking selectedBooking) {
        this.log.infov("Canceling booking {0} for {1}", (Object)selectedBooking.getId(), (Object)((User)this.currentUserInstance.get()).getName());
        Booking booking = (Booking)this.entityManager.find(Booking.class, (Object)selectedBooking.getId());
        if (booking != null) {
            this.entityManager.remove((Object)booking);
            this.messages.info((BundleKey)new DefaultBundleKey("booking_canceled")).defaults("The booking at the {0} on {1} has been canceled.").params(new Object[]{selectedBooking.getHotel().getName(), DateFormat.getDateInstance(2).format(selectedBooking.getCheckinDate())});
        } else {
            this.messages.info((BundleKey)new DefaultBundleKey("booking_doesNotExist")).defaults("Our records indicate that the booking you selected has already been canceled.");
        }
        this.bookingsForUser.remove(selectedBooking);
    }

    private void fetchBookingsForCurrentUser() {
        String username = ((User)this.currentUserInstance.get()).getUsername();
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cquery = builder.createQuery(Booking.class);
        Root booking = cquery.from(Booking.class);
        booking.fetch(Booking_.hotel, JoinType.INNER);
        cquery.select((Selection)booking).where((Expression)builder.equal((Expression)booking.get(Booking_.user).get(User_.username), (Object)username)).orderBy(new Order[]{builder.asc((Expression)booking.get(Booking_.checkinDate))});
        this.bookingsForUser = this.entityManager.createQuery(cquery).getResultList();
    }
}

