/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.seam.solder.core.Veto;

@Entity
@Table(name="hotel")
@Veto
public class Hotel
implements Serializable {
    private Long id;
    private String name;
    private String address;
    private String city;
    private String state;
    private String zip;
    private String country;
    private Integer stars;
    private BigDecimal price;

    public Hotel() {
    }

    public Hotel(String name, String address, String city, String state, String zip, String country) {
        this.name = name;
        this.address = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.country = country;
    }

    public Hotel(int price, int stars, String name, String address, String city, String state, String zip, String country) {
        this.price = new BigDecimal(price);
        this.stars = stars;
        this.name = name;
        this.address = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.country = country;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Size(max=50)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Size(max=100)
    @NotNull
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Size(max=40)
    @NotNull
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Size(min=3, max=6)
    @NotNull
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @Size(min=2, max=10)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Size(min=2, max=40)
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Min(value=1L)
    @Max(value=5L)
    public Integer getStars() {
        return this.stars;
    }

    public void setStars(Integer stars) {
        this.stars = stars;
    }

    @Column(precision=6, scale=2)
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Transient
    public String getLocation() {
        return this.city + ", " + this.state + ", " + this.country;
    }

    public String toString() {
        return "Hotel(" + this.name + "," + this.address + "," + this.city + "," + this.zip + ")";
    }
}

