/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.security;

import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.logging.Logger;
import org.jboss.seam.examples.booking.account.Authenticated;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Credentials;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.model.SimpleUser;

@Stateless
@Named(value="bookingAuthenticator")
public class BookingAuthenticator
extends BaseAuthenticator
implements Authenticator {
    @Inject
    private Logger log;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Credentials credentials;
    @Inject
    private Messages messages;
    @Inject
    @Authenticated
    private Event<User> loginEventSrc;

    public void authenticate() {
        User user;
        this.log.info((Object)("Logging in " + this.credentials.getUsername()));
        if (this.credentials.getUsername() == null || this.credentials.getCredential() == null) {
            this.messages.error((BundleKey)new DefaultBundleKey("identity_loginFailed")).defaults("Invalid username or password");
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
        }
        if ((user = (User)this.em.find(User.class, (Object)this.credentials.getUsername())) != null && this.credentials.getCredential() instanceof PasswordCredential && user.getPassword().equals(((PasswordCredential)this.credentials.getCredential()).getValue())) {
            this.loginEventSrc.fire((Object)user);
            this.messages.info((BundleKey)new DefaultBundleKey("identity_loggedIn"), new Object[]{user.getName()}).defaults("You're signed in as {0}").params(new Object[]{user.getName()});
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setUser((org.picketlink.idm.api.User)new SimpleUser(user.getUsername()));
            return;
        }
        this.messages.error((BundleKey)new DefaultBundleKey("identity_loginFailed")).defaults("Invalid username or password");
        this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
    }
}

