/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.account;

import javax.ejb.Stateful;
import javax.enterprise.inject.Model;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.seam.examples.booking.account.Authenticated;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;

@Stateful
@Model
public class PasswordManager {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Messages messages;
    @Inject
    @Authenticated
    private User user;
    @NotNull
    @Size(min=5, max=15)
    private String confirmPassword;
    private boolean changed;

    public void changePassword() {
        this.em.merge((Object)this.user);
        this.messages.info((BundleKey)new DefaultBundleKey("account_passwordChanged")).defaults("Password successfully updated.");
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setConfirmPassword(String password) {
        this.confirmPassword = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }
}

