/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.booking;

import com.ocpsoft.pretty.time.PrettyTime;
import java.util.Locale;
import javax.ejb.Stateful;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.seam.examples.booking.account.Authenticated;
import org.jboss.seam.examples.booking.booking.Confirmed;
import org.jboss.seam.examples.booking.i18n.DefaultBundleKey;
import org.jboss.seam.examples.booking.log.BookingLog;
import org.jboss.seam.examples.booking.model.Booking;
import org.jboss.seam.examples.booking.model.Hotel;
import org.jboss.seam.examples.booking.model.User;
import org.jboss.seam.faces.context.conversation.Begin;
import org.jboss.seam.faces.context.conversation.ConversationBoundaryInterceptor;
import org.jboss.seam.faces.context.conversation.End;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.international.status.builder.BundleKey;
import org.jboss.seam.international.status.builder.TemplateMessage;
import org.jboss.solder.logging.TypedCategory;

@Stateful
@ConversationScoped
@Named
@Interceptors(value={ConversationBoundaryInterceptor.class})
public class BookingAgent {
    @Inject
    @TypedCategory(value=BookingAgent.class)
    private BookingLog log;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    private EntityManager em;
    @Inject
    private Instance<TemplateMessage> messageBuilder;
    @Inject
    private Messages messages;
    @Inject
    @Authenticated
    private User user;
    @Inject
    private Locale locale;
    @Inject
    @Confirmed
    private Event<Booking> bookingConfirmedEventSrc;
    private Hotel hotelSelection;
    private Booking booking;
    private boolean bookingValid;
    @Inject
    private Conversation conversation;

    @Begin
    public void selectHotel(Long id) {
        this.conversation.setTimeout(600000L);
        this.hotelSelection = (Hotel)this.em.find(Hotel.class, (Object)id);
        if (this.hotelSelection != null) {
            this.log.hotelSelected(this.user != null ? this.user.getName() : "Anonymous", this.hotelSelection.getName(), this.hotelSelection.getCity());
        }
    }

    public void bookHotel() {
        this.booking = new Booking(this.hotelSelection, this.user, 7, 2);
        this.hotelSelection = null;
        this.booking.setCreditCardNumber("1111222233334444");
        this.log.bookingInitiated(this.user.getName(), this.booking.getHotel().getName());
        this.messages.info((BundleKey)new DefaultBundleKey("booking_initiated")).defaults("You've initiated a booking at the {0}.").params(new Object[]{this.booking.getHotel().getName()});
    }

    public void validate() {
        this.log.hotelEntityInPersistenceContext(this.em.contains((Object)this.booking.getHotel()));
        this.bookingValid = true;
    }

    @End
    public void confirm() {
        this.em.persist((Object)this.booking);
        this.bookingConfirmedEventSrc.fire((Object)this.booking);
    }

    @End
    public void cancel() {
        this.booking = null;
        this.hotelSelection = null;
    }

    public void onBookingComplete(@Observes(during=TransactionPhase.AFTER_SUCCESS) @Confirmed Booking booking) {
        this.log.bookingConfirmed(booking.getHotel().getName(), booking.getUser().getName());
        this.messages.info((BundleKey)new DefaultBundleKey("booking_confirmed")).defaults("You're booked to stay at the {0} {1}.").params(new Object[]{booking.getHotel().getName(), new PrettyTime(this.locale).format(booking.getCheckinDate())});
    }

    @Produces
    @ConversationScoped
    @Named
    public Booking getBooking() {
        return this.booking;
    }

    @Produces
    @RequestScoped
    @Named(value="hotel")
    public Hotel getSelectedHotel() {
        return this.booking != null ? this.booking.getHotel() : this.hotelSelection;
    }

    public boolean isBookingValid() {
        return this.bookingValid;
    }
}

