/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.inventory;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;

@Named
@SessionScoped
public class SearchCriteria
implements Serializable {
    private static final char SQL_WILDCARD_CHAR = '%';
    private static final String SQL_WILDCARD_STR = String.valueOf('%');
    private static final String REPEAT_SQL_WIDCARD_REGEX = SQL_WILDCARD_STR + "+";
    private static final char HUMAN_WILDCARD_CHAR = '*';
    private String query = "";
    private int pageSize = 5;
    private int page = 0;

    public String getSearchPattern() {
        if (this.query == null || this.query.length() == 0) {
            return SQL_WILDCARD_STR;
        }
        StringBuilder pattern = new StringBuilder();
        pattern.append(this.query.toLowerCase().replace('*', '%').replaceAll(REPEAT_SQL_WIDCARD_REGEX, SQL_WILDCARD_STR));
        if (pattern.length() == 0 || pattern.charAt(0) != '%') {
            pattern.insert(0, '%');
        }
        if (pattern.length() > 1 && pattern.charAt(pattern.length() - 1) != '%') {
            pattern.append('%');
        }
        return pattern.toString();
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getFetchSize() {
        return this.pageSize + 1;
    }

    public int getFetchOffset() {
        return this.page * this.pageSize;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query != null ? query.trim() : null;
    }

    public void nextPage() {
        ++this.page;
    }

    public void previousPage() {
        if (this.page > 0) {
            --this.page;
        }
    }

    public void firstPage() {
        this.page = 0;
    }
}

