/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.examples.booking.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.jboss.solder.core.Veto;

@Entity
@Table(name="traveler")
@Veto
public class User
implements Serializable {
    private static final long serialVersionUID = -602733026033932730L;
    private String username;
    private String password;
    private String name;
    private String email;

    public User() {
    }

    public User(String name, String username, String email) {
        this.name = name;
        this.username = username;
        this.email = email;
    }

    public User(String name, String username, String email, String password) {
        this(name, username, email);
        this.password = password;
    }

    @NotNull
    @Size(min=1, max=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    @Size(min=5, max=15)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Id
    @NotNull
    @Size(min=3, max=15)
    @Pattern(regexp="^\\w*$", message="not a valid username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @NotNull
    @Email
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Transient
    public String getEmailWithName() {
        return this.name + " <" + this.email + ">";
    }

    public String toString() {
        return "User(" + this.username + ")";
    }
}

