/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.component.FacesComponent;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.faces.event.qualifier.After;
import org.jboss.seam.faces.event.qualifier.Before;
import org.jboss.seam.solder.beanManager.BeanManagerLocator;
import org.jboss.seam.solder.logging.Logger;

@FacesComponent(value="org.jboss.seam.faces.ValidateForm")
public class UIValidateForm
extends UIInput {
    private Logger log = Logger.getLogger(UIValidateForm.class);
    private static final AnnotationLiteral<Before> BEFORE = new AnnotationLiteral<Before>(){
        private static final long serialVersionUID = 7631699535063526392L;
    };
    private static final AnnotationLiteral<After> AFTER = new AnnotationLiteral<After>(){
        private static final long serialVersionUID = -929128236303355107L;
    };
    public static final String COMPONENT_TYPE = "org.jboss.seam.faces.ValidateForm";
    public static final String COMPONENT_FAMILY = "org.jboss.seam.faces.ValidateForm";
    private static final String VALIDATOR_ID_KEY = "org.jboss.seam.faces.ValidateForm_ID_KEY";
    private static final Serializable COMPONENTS_MAP_KEY = "org.jboss.seam.faces.ValidateForm_COMPONENTS_MAP_KEY";
    private static final Serializable FIELDS_KEY = "org.jboss.seam.faces.ValidateForm_FIELDS_KEY";
    private static final Serializable SHOW_FIELD_MESSAGES_KEY = "org.jboss.seam.faces.ValidateForm_SHOW_FIELD_MESSAGES";
    private static final Serializable SHOW_GLOBAL_MESSAGES_KEY = "org.jboss.seam.faces.ValidateForm_SHOW_GLOBAL_MESSAGES";

    public String getFamily() {
        return "org.jboss.seam.faces.ValidateForm";
    }

    public String getRendererType() {
        return null;
    }

    public void validate(FacesContext context) {
        BeanManager manager;
        block7: {
            context.getApplication().publishEvent(context, PreValidateEvent.class, UIValidateForm.class, (Object)this);
            manager = new BeanManagerLocator().getBeanManager();
            manager.fireEvent((Object)this, new Annotation[]{BEFORE});
            Validator validator = null;
            try {
                validator = context.getApplication().createValidator(this.getValidatorId());
                if (validator == null) {
                    throw new IllegalArgumentException("Seam UIValidateForm - Could not create Validator with id: [" + this.getValidatorId() + "]");
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Seam UIValidateForm - Could not create validator with id [" + this.getValidatorId() + "] because: nested exception is:" + e.getMessage(), e);
            }
            Map<String, UIInput> components = this.getComponents();
            try {
                UIComponent parent = this.getParent();
                validator.validate(context, parent, components);
            }
            catch (ValidatorException e) {
                this.setValid(false);
                for (UIInput comp : components.values()) {
                    comp.setValid(false);
                    if (!this.isShowFieldMessages()) continue;
                    context.addMessage(comp.getClientId(), e.getFacesMessage());
                }
                if (this.isShowGlobalMessages()) {
                    context.addMessage(null, e.getFacesMessage());
                }
                if (this.isShowGlobalMessages() || this.isShowFieldMessages()) break block7;
                this.log.warn((Object)"The form validation failed but neither 'showFieldMessages' nor 'showGlobalMessages' is true. The validation messages will be dropped.");
            }
        }
        manager.fireEvent((Object)this, new Annotation[]{AFTER});
        context.getApplication().publishEvent(context, PostValidateEvent.class, UIValidateForm.class, (Object)this);
    }

    public UIForm locateForm() {
        UIComponent parent = this.getParent();
        while (!(parent instanceof UIForm)) {
            if (parent == null || parent instanceof UIViewRoot) {
                throw new IllegalStateException("The UIValidateForm (<s:validateForm />) component must be placed within a UIForm (<h:form>)");
            }
            parent = parent.getParent();
        }
        return (UIForm)parent;
    }

    public void encodeAll(FacesContext context) throws IOException {
        this.locateForm();
    }

    public void encodeBegin(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public String getFields() {
        StateHelper helper = this.getStateHelper(true);
        return (String)helper.get(FIELDS_KEY);
    }

    public void setFields(String fields) {
        StateHelper helper = this.getStateHelper(true);
        helper.put(FIELDS_KEY, (Object)fields);
    }

    public String getValidatorId() {
        StateHelper helper = this.getStateHelper(true);
        return (String)helper.get((Serializable)((Object)VALIDATOR_ID_KEY));
    }

    public void setValidatorId(String validatorId) {
        StateHelper helper = this.getStateHelper(true);
        helper.put((Serializable)((Object)VALIDATOR_ID_KEY), (Object)validatorId);
    }

    public boolean isShowFieldMessages() {
        StateHelper helper = this.getStateHelper(true);
        return (Boolean)helper.eval(SHOW_FIELD_MESSAGES_KEY, (Object)false);
    }

    public void setShowFieldMessages(boolean showFieldMessages) {
        StateHelper helper = this.getStateHelper(true);
        helper.put(SHOW_FIELD_MESSAGES_KEY, (Object)showFieldMessages);
    }

    public boolean isShowGlobalMessages() {
        StateHelper helper = this.getStateHelper(true);
        return (Boolean)helper.eval(SHOW_GLOBAL_MESSAGES_KEY, (Object)true);
    }

    public void setShowGlobalMessages(boolean showGlobalMessages) {
        StateHelper helper = this.getStateHelper(true);
        helper.put(SHOW_GLOBAL_MESSAGES_KEY, (Object)showGlobalMessages);
    }

    private Map<String, UIInput> getComponents() {
        StateHelper helper = this.getStateHelper(true);
        return (Map)helper.get(COMPONENTS_MAP_KEY);
    }

    public void setComponents(Map<String, UIInput> components) {
        StateHelper helper = this.getStateHelper(true);
        helper.put(COMPONENTS_MAP_KEY, components);
    }
}

