/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesAnnotationsAdapterExtension
implements Extension {
    private final Map<Class<? extends Annotation>, Class<? extends Annotation>> scopeAliasMapping = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>(3);
    private static final Map<Class<?>, Class<? extends Annotation>> aliasedBeans = new HashMap();

    public static Map<Class<?>, Class<? extends Annotation>> getAliasedbeans() {
        return aliasedBeans;
    }

    public FacesAnnotationsAdapterExtension() {
        this.scopeAliasMapping.put(RequestScoped.class, javax.enterprise.context.RequestScoped.class);
        this.scopeAliasMapping.put(javax.faces.bean.SessionScoped.class, SessionScoped.class);
        this.scopeAliasMapping.put(javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class);
    }

    public void aliasJsfScopeIfDetected(@Observes ProcessAnnotatedType<Object> annotatedType) {
        for (Class<? extends Annotation> scope : this.scopeAliasMapping.keySet()) {
            if (!annotatedType.getAnnotatedType().isAnnotationPresent(scope)) continue;
            System.out.println("WARNING: Please annotate class " + annotatedType.getAnnotatedType().getJavaClass() + " with @" + this.scopeAliasMapping.get(scope).getName() + " instead of @" + scope.getName());
            aliasedBeans.put(annotatedType.getAnnotatedType().getJavaClass(), scope);
            annotatedType.setAnnotatedType(this.decorateType((AnnotatedType<Object>)annotatedType.getAnnotatedType(), scope));
            break;
        }
    }

    public void failIfJsfManagedBeanAnnotationPresent(@Observes ProcessBean<?> bean) {
        if (bean.getAnnotated().isAnnotationPresent(ManagedBean.class)) {
            bean.addDefinitionError((Throwable)new RuntimeException("Use of @javax.faces.bean.ManagedBean is forbidden. Please use @javax.inject.Named instead."));
        }
    }

    private Class<? extends Annotation> getCdiScopeFor(Class<? extends Annotation> jsfScope) {
        return this.scopeAliasMapping.get(jsfScope);
    }

    private AnnotatedType<Object> decorateType(final AnnotatedType<Object> type, final Class<? extends Annotation> jsfScope) {
        final Class<? extends Annotation> cdiScope = this.getCdiScopeFor(jsfScope);
        final Annotation cdiScopeAnnotation = new Annotation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return cdiScope;
            }
        };
        final HashSet<1> maskedAnnotations = new HashSet<1>(type.getAnnotations());
        maskedAnnotations.remove(type.getAnnotation(jsfScope));
        maskedAnnotations.add(cdiScopeAnnotation);
        return new AnnotatedType<Object>(){

            public Class<Object> getJavaClass() {
                return type.getJavaClass();
            }

            public Set<AnnotatedConstructor<Object>> getConstructors() {
                return type.getConstructors();
            }

            public Set<AnnotatedMethod<? super Object>> getMethods() {
                return type.getMethods();
            }

            public Set<AnnotatedField<? super Object>> getFields() {
                return type.getFields();
            }

            public Type getBaseType() {
                return type.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return type.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                if (annotationType == jsfScope) {
                    return null;
                }
                if (annotationType == cdiScope) {
                    return (T)cdiScopeAnnotation;
                }
                return (T)type.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return maskedAnnotations;
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                if (annotationType == jsfScope) {
                    return false;
                }
                if (annotationType == cdiScope) {
                    return true;
                }
                return type.isAnnotationPresent(annotationType);
            }
        };
    }
}

