/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.context.conversation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.context.conversation.Begin;
import org.jboss.seam.faces.context.conversation.ConversationBoundary;
import org.jboss.seam.faces.context.conversation.End;
import org.jboss.seam.faces.util.Annotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConversationBoundary
@Interceptor
public class ConversationBoundaryInterceptor
implements Serializable {
    private static final long serialVersionUID = -2729227895205287477L;
    Logger log = Logger.getLogger(ConversationBoundaryInterceptor.class);
    @Inject
    Conversation conversation;

    @AroundInvoke
    public Object around(InvocationContext ctx) throws Exception {
        Object result = null;
        try {
            if (Annotations.isAnnotationPresent(ctx.getMethod(), Begin.class)) {
                this.beginConversation(ctx);
            }
            result = ctx.proceed();
            if (Annotations.isAnnotationPresent(ctx.getMethod(), End.class)) {
                this.endConversation(ctx);
            }
        }
        catch (Exception e) {
            this.handleExceptionBegin(ctx, e);
            this.handleExceptionEnd(ctx, e);
            throw e;
        }
        return result;
    }

    private void handleExceptionBegin(InvocationContext ctx, Exception e) {
        if (Annotations.isAnnotationPresent(ctx.getMethod(), Begin.class)) {
            List<? extends Class<? extends Exception>> typesPermittedByBegin = this.getPermittedExceptionTypesBegin(ctx.getMethod());
            for (Class<? extends Exception> clazz : typesPermittedByBegin) {
                if (clazz.isInstance(e)) continue;
                this.log.debug((Object)"Aborting conversation: (#0) for method: (#1.#2(...)) - Encountered Exception of type (#4), which is not in the list of exceptions permitted by @Begin.", new Object[]{this.conversation.getId(), ctx.getMethod().getDeclaringClass().getName(), ctx.getMethod().getName(), e.getClass().getName()});
                this.conversation.end();
            }
        }
    }

    private void handleExceptionEnd(InvocationContext ctx, Exception e) {
        if (Annotations.isAnnotationPresent(ctx.getMethod(), End.class)) {
            List<? extends Class<? extends Exception>> typesPermittedByEnd = this.getPermittedExceptionTypesEnd(ctx.getMethod());
            boolean permitted = false;
            for (Class<? extends Exception> clazz : typesPermittedByEnd) {
                if (!clazz.isInstance(e)) continue;
                permitted = true;
                this.conversation.end();
            }
            if (!permitted) {
                this.log.debug((Object)"Conversation will remain open: (#0) for method: (#1.#2(...)) - Encountered Exception of type (#4), which is not in the list of exceptions permitted by @End.", new Object[]{this.conversation.getId(), ctx.getMethod().getDeclaringClass().getName(), ctx.getMethod().getName(), e.getClass().getName()});
            }
        }
    }

    private void beginConversation(InvocationContext ctx) throws Exception {
        String cid = Annotations.getAnnotation(ctx.getMethod(), Begin.class).id();
        if (cid != null && !"".equals(cid)) {
            this.conversation.begin(cid);
        } else {
            this.conversation.begin();
        }
        long timeout = Annotations.getAnnotation(ctx.getMethod(), Begin.class).timeout();
        if (timeout != -1L) {
            this.conversation.setTimeout(timeout);
        }
        this.log.debug((Object)"Began conversation: (#0) before method: (#1.#2(...))", new Object[]{this.conversation.getId(), ctx.getMethod().getDeclaringClass().getName(), ctx.getMethod().getName()});
    }

    private void endConversation(InvocationContext ctx) {
        this.log.debug((Object)"Ending conversation: (#0) after method: (#1.#2(...))", new Object[]{this.conversation.getId(), ctx.getMethod().getDeclaringClass().getName(), ctx.getMethod().getName()});
        this.conversation.end();
    }

    private List<? extends Class<? extends Exception>> getPermittedExceptionTypesBegin(Method m) {
        return Arrays.asList(Annotations.getAnnotation(m, Begin.class).permit());
    }

    private List<? extends Class<? extends Exception>> getPermittedExceptionTypesEnd(Method m) {
        return Arrays.asList(Annotations.getAnnotation(m, End.class).permit());
    }
}

