/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.seam.faces.component.FormValidationTypeOverrideExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagerUtils {
    @Inject
    private BeanManager manager;
    @Inject
    private FormValidationTypeOverrideExtension classExtension;

    public void injectNonContextualInstance(Object instance) {
        if (instance != null) {
            CreationalContext creationalContext = this.manager.createCreationalContext(null);
            InjectionTarget injectionTarget = this.manager.createInjectionTarget(this.getAnnotatedType(instance));
            injectionTarget.inject(instance, creationalContext);
        }
    }

    private AnnotatedType<? extends Object> getAnnotatedType(Object instance) {
        AnnotatedType result = null;
        result = this.classExtension.hasOverriddenType(instance.getClass()) ? this.classExtension.getOverriddenType(instance.getClass()) : this.manager.createAnnotatedType(instance.getClass());
        return result;
    }

    public <T> boolean isDependentScoped(Class<T> type) {
        Bean bean = this.manager.resolve(this.manager.getBeans(type, new Annotation[0]));
        if (bean != null) {
            return Dependent.class.equals((Object)bean.getScope());
        }
        return false;
    }

    public <T> T getContextualInstance(Class<T> type) {
        return BeanManagerUtils.getContextualInstance(this.manager, type);
    }

    public static <T> T getContextualInstance(BeanManager manager, Class<T> type) {
        CreationalContext context;
        Object result = null;
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean != null && (context = manager.createCreationalContext((Contextual)bean)) != null) {
            result = manager.getReference(bean, type, context);
        }
        return (T)result;
    }

    public <T> List<T> getContextualInstances(Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Bean bean : this.manager.getBeans(type, new Annotation[0])) {
            CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
            if (context == null) continue;
            result.add(this.manager.getReference(bean, type, context));
        }
        return result;
    }
}

