/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.environment;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ApplicationWrapper;
import javax.faces.convert.Converter;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.validator.Validator;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.util.BeanManagerUtils;

@ApplicationScoped
public class SeamApplicationWrapper
extends ApplicationWrapper {
    private final transient Logger log = Logger.getLogger(SeamApplicationWrapper.class);
    private Application parent;
    @Inject
    BeanManagerUtils managerUtils;

    public Application getWrapped() {
        return this.parent;
    }

    public void installWrapper(@Observes PostConstructApplicationEvent event) {
        this.log.debug((Object)"PostConstructApplicationEvent observed, installing wrapper");
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.parent = event.getApplication();
        factory.setApplication((Application)this);
    }

    public Converter createConverter(Class<?> targetClass) {
        this.log.debugf("Creating converter for targetClass %s", (Object)targetClass.getName());
        Converter result = this.parent.createConverter(targetClass);
        result = this.attemptExtension(result);
        return result;
    }

    public Converter createConverter(String converterId) {
        this.log.debugf("Creating converter for converterId %s", (Object)converterId);
        Converter result = this.parent.createConverter(converterId);
        result = this.attemptExtension(result);
        return result;
    }

    public Validator createValidator(String validatorId) {
        this.log.debugf("Creating validator for validatorId %s", (Object)validatorId);
        Validator result = this.parent.createValidator(validatorId);
        result = this.attemptExtension(result);
        return result;
    }

    private <T> T attemptExtension(T base) {
        Object result = base;
        if (base == null) {
            this.log.warnf("Cannot attempt extension on null", new Object[0]);
            return null;
        }
        this.log.debugf("Extending class: %s", (Object)base.getClass().getName());
        if (this.managerUtils.isDependentScoped(base.getClass())) {
            this.managerUtils.injectNonContextualInstance(result);
        } else {
            result = this.managerUtils.getContextualInstance(base.getClass());
        }
        if (result == null) {
            this.log.warnf("Using JSF provided instance, unable to find a BeanManaged instance for class %s", (Object)base.getClass().getName());
            result = base;
        }
        return result;
    }
}

