/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.event;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.component.UIViewRoot;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostConstructViewMapEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.inject.Inject;
import org.jboss.seam.faces.event.qualifier.Component;
import org.jboss.seam.faces.event.qualifier.View;

public class SystemEventBridge
implements SystemEventListener {
    @Inject
    BeanManager beanManager;

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public void processEvent(SystemEvent e) throws AbortProcessingException {
        Object payload = e.getClass().cast(e);
        Annotation[] qualifiers = this.getQualifiers(e);
        this.beanManager.fireEvent(payload, qualifiers);
    }

    private Annotation[] getQualifiers(SystemEvent e) {
        if (this.isViewEvent(e)) {
            String id = ((UIViewRoot)e.getSource()).getViewId();
            return new Annotation[]{new ViewLiteral(id)};
        }
        if (e instanceof ComponentSystemEvent) {
            String id = ((ComponentSystemEvent)e).getComponent().getId();
            return new Annotation[]{new ComponentLiteral(id)};
        }
        return new Annotation[0];
    }

    private boolean isViewEvent(SystemEvent e) {
        return e instanceof PreRenderViewEvent || e instanceof PostConstructViewMapEvent || e instanceof PreDestroyViewMapEvent;
    }

    private class ViewLiteral
    extends AnnotationLiteral<View>
    implements View {
        private static final long serialVersionUID = -9101103836360031181L;
        private String value = "";

        public String value() {
            return this.value;
        }

        public ViewLiteral(String value) {
            if (value != null) {
                this.value = value;
            }
        }
    }

    private class ComponentLiteral
    extends AnnotationLiteral<Component>
    implements Component {
        private static final long serialVersionUID = -180390717920002323L;
        private String value = "";

        public String value() {
            return this.value;
        }

        public ComponentLiteral(String value) {
            if (value != null) {
                this.value = value;
            }
        }
    }
}

